/***************************************************************************
 * optionsmidi.h: implementation of OptionsMidi class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef TIMIDITY_H
#define TIMIDITY_H

#include <header.h>

class Timidity: public QWidget {
	Q_OBJECT
public:
	Timidity(QWidget* parent = 0, const char* name = 0);
	
	virtual void writeConfig();
	
	bool isTimidityWanted() const;
	void buildCmdLine(QProcess& process) const;
private slots:
	void search();
	void launchTimidity();
	
private:
	virtual void fillOptions();
	
	QCheckBox midiTimidity;
	
	QLabel timidityPathLabel;
	QLineEdit timidityPath;
	QPushButton timidityButton;
	
	QLabel bufferLabel;
	QSpinBox buffer;
	
	QLabel fragmentLabel;
	QSpinBox fragment;
	
	QLabel outputLabel;
	QComboBox output;
	
	QLabel chorusLabel;
	QComboBox chorus;
	
	QLabel delayLabel;
	QComboBox delay;
	
	QLabel reverbLabel;
	QComboBox reverb;
	
	QLabel vlpfLabel;
	QComboBox vlpf;
	
	QLabel noiseLabel;
	QComboBox noise;
	
	QLabel resampLabel;
	QComboBox resamp;
	
	QLabel frequencyLabel;
	QSpinBox frequency;
	
	QLabel realtimeEnableLabel;
	QCheckBox realtimeEnable;
	
	QLabel realtimeLabel;
	QSpinBox realtime;
	
	QVBoxLayout timidityLayout;
	QVBoxLayout bufferLayout;
	QVBoxLayout fragmentLayout;
	QVBoxLayout outputLayout;
	QVBoxLayout chorusLayout;
	QVBoxLayout delayLayout;
	QVBoxLayout reverbLayout;
	QVBoxLayout vlpfLayout;
	QVBoxLayout noiseLayout;
	QVBoxLayout resampLayout;
	QVBoxLayout frequencyLayout;
	QVBoxLayout realtimeEnableLayout;
	QVBoxLayout realtimeLayout;
	
	QHBoxLayout timidityPathLayout;
};

#endif
