/***************************************************************************
 * timiditylauncher.h: implementation of TimidityLauncher class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef TimidityLauncher_H
#define TimidityLauncher_H

#include <header.h>

class TimidityLauncher : public QProcess {
	Q_OBJECT
public:
	TimidityLauncher(QWidget* parent = 0, const char* name = 0);
	~TimidityLauncher();
	
	bool launchTimidity();
	
	QString errorMsg();
	
private slots:
	void readFromStdout();
	void readFromStderr();
	
private:
	// Build the command line
	//
	void setupTimidity();
	
	// Timidity standart output
	//
	QString result;
	
	// Timidity error output
	//
	QString error;
};

#endif
