/***************************************************************************
 * chordlist.h: implementation of ChordList class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef CHORDLIST_H
#define CHORDLIST_H

#include <header.h>

class ChordListItem;

/*!
	Inherits from qlisbox and add two fonctions members.
*/
class ChordList: public QListBox
{
    Q_OBJECT
public:
	/*!
		Constructor
	*/
	ChordList(QWidget *parent=0, const char *name=0);
	
	/*!
		Get the current item
		\return a pointer for the current item
	*/
	ChordListItem* currentItemPointer();
	
	/*!
		Insert an item and sort the list.
		\param it the item
	*/
	void inSort(ChordListItem *it);
};

#endif
