/***************************************************************************
 * clipboard.h: implementation of Clipboard class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef CLIPBOARD_H
#define CLIPBOARD_H

#include <header.h>

class Clipboard : public QDialog {
Q_OBJECT
public:
	Clipboard(uint begin, uint bar,QWidget* parent=0, const char* name=0);
	~Clipboard();
	
	uint getFrom();
	uint getTo();
	
private slots:
	void okClick();
	void cancelClick();
	
private:
	QGridLayout layout;
	QLabel fromLabel, toLabel;
	QSpinBox from, to;
	QPushButton ok, cancel;
	QCheckBox toEnd;
	uint lastBar;
};

#endif
