/***************************************************************************
 * fileimport.h: implementation of FileImport class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef FILEIMPORT_H
#define FILEIMPORT_H

#include <header.h>

class TabSong;

//! Abstract base class for all converters.
/*!
	Pure abstract base class to define basic structure of all
	converters - classes that manage loading / saving of internal
	KGuitar representation of tabulature data into some file format.
*/
class FileImport
{
public:
	/*!
		Called to load data from file named fileName into TabSong.
	*/
	virtual TabSong loadFile(const QString &) = 0;
	
	/*!
		Called to save current data from TabSong into file named
		fileName.
	*/
	virtual bool saveFile(const QString &, const TabSong &) = 0;
};

#endif
