/***************************************************************************
 * guitarpro.h: implementation of GuitarPro class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef GUITARPRO_H
#define GUITARPRO_H

#include <header.h>

#include "fileimport.h"

class TabBar;
class TabBarProperties;
class TabChord;
class TrackMidiProperties;
class TabSong;
class TabTimes;

/*!
	TODO
*/
class GuitarPro : public FileImport
{
public:
	/*!
		TODO
	*/
	GuitarPro();
	
	/*!
		TODO
	*/
	virtual ~GuitarPro();
	
	/*!
		TODO
	*/
	TabSong loadFile(const QString &);
	
	/*!
		TODO
	*/
	bool saveFile(const QString &, const TabSong &);
private:
	void readHeader(TabSong&);
	void readMidi();
	void readBars(TabSong&);
	void readTracks(TabSong&);
	
	TabChord readChords();
	void readChanges(TabBar& bar);
	void readEffects(TabTimes& notes);
	void readNotes(bool rest, uchar beatduration, TabTimes& times, uint noteLength);
	
	unsigned char *buffer;
	unsigned char *buf;
	long size, totalsize;
	unsigned int nbbars, nbtrack;
	
	unsigned char getBeatDuration();
	
	inline bool isChar(unsigned char c);
	unsigned char getByte();
	inline unsigned long getLong();
	inline QString getString();
	inline QString getStringNoInc(int i);
	inline void dummies(int);
	
	QValueVector<TrackMidiProperties> instruments;
	QValueVector<TabBarProperties> trackProperties;
};

#endif
