/***************************************************************************
 * fretboard.h: implementation of FretBoard class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef FRETBOARD_H
#define FRETBOARD_H

#include <header.h>

#include "global.h"
#include "tablature/tabtimes.h"

class TabTrack;

/*!
	TODO
*/
class Fretboard: public QWidget {
	Q_OBJECT
public:
	/*!
		TODO
	*/
	Fretboard(TabTrack *, QWidget *parent = 0, const char *name = 0);
	
	/*!
		TODO
	*/
	~Fretboard();

public slots:
	/*!
		TODO
	*/
	void setTrack(TabTrack *);
	
	/*!
		TODO
	*/
	void setTonic(int);
	
	/*!
		TODO
	*/
	void setMode(int);
	
	/*!
		TODO
	*/
	void drawBackground();
	
	/*!
		TODO
	*/
	void drawScaleBack();
	
	/*
		The refresh the fretboard
	*/
	void refresh(const TabTimes&);
	
signals:
	void buttonPress(int, int, ButtonState);
	void buttonRelease(ButtonState);

protected:
	virtual void paintEvent(QPaintEvent *);
	virtual void mousePressEvent(QMouseEvent *);
	virtual void mouseMoveEvent(QMouseEvent *);
	virtual void mouseReleaseEvent(QMouseEvent *);
	virtual void resizeEvent(QResizeEvent *);
	virtual QSizePolicy sizePolicy();

private:
	void handleMouse(QMouseEvent *);
	void recalculateSizes();
	
	TabTrack *trk;
	TabTimes times;
	
	double fr[MAX_FRETS + 1]; // Proper physical fret positions
	QPixmap *scaleback, *back, *wood;
	QImage *fret, *zeroFret;
	
	int tonic;
	int mode;
};

#endif
