#include "logger.h"

Logger ktabLog;

bool Logger::inst = false;

Logger::Logger()
{
	if (inst)
		return ;
	
	QDir homeDir(QDir::home());
	
	// Create ktabedit dir where the the file is 
	// unzip, the file is deleted after the parsing.
	//
	if (!homeDir.cd(".ktabedit"))
		if (homeDir.mkdir(".ktabedit") == false)
			throw "Unable to create .ktabedit directory";
	
	file.setName(homeDir.absPath() + "/ktabedit.log");
	
	inst = true;
	
	if (file.open(IO_WriteOnly))
		stream.setDevice(&file);
	else
		return ;
}

Logger::~Logger()
{
	file.close();
}

Logger& Logger::operator<<(QChar c)
{
	stream << c;
	
	return *this;
}

Logger& Logger::operator<<(char c)
{
	stream << c;
	
	return *this;
}

Logger& Logger::operator<<(signed short i)
{
	stream << i;
	
	return *this;
}

Logger& Logger::operator<<(unsigned short i)
{
	stream << i;
	
	return *this;
}

Logger& Logger::operator<<(signed int i)
{
	stream << i;
	
	return *this;
}

Logger& Logger::operator<<(unsigned int i)
{
	stream << i;
	
	return *this;
}

Logger& Logger::operator<<(signed long i)
{
	stream << i;
	
	return *this;
}

Logger& Logger::operator<<(unsigned long i)
{
	stream << i;
	
	return *this;
}

Logger& Logger::operator<<(float f)
{
	stream << f;
	
	return *this;
}

Logger& Logger::operator<<(double f)
{
	stream << f;
	
	return *this;
}

Logger& Logger::operator<<(const char *s)
{
	stream << s;
	
	return *this;
}

Logger& Logger::operator<<(const QString &s)
{
	stream << s;
	
	return *this;
}

Logger& Logger::operator<<(void *ptr)
{
	stream << ptr;
	
	return *this;
}

Logger& Logger::operator<<(const QColor &color)
{
	stream << color.red() << " " << color.green() << " " << color.blue();
	
	return *this;
}
