/***************************************************************************
 * optionsscore.cpp: implementation of OptionsScore class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#include "optionsscore.h"
#include "settings.h"

OptionsScore::OptionsScore(KConfig *conf, QWidget *parent, const char *name)
: OptionsPage(conf, parent, name),
  titleLabel(i18n("Title"), this),
  titleText(this),
  titleButton("...", this),
  subTitleLabel(i18n("Subtitle"), this),
  subTitleText(this),
  subTitleButton("...", this),
  textAndTabLabel(i18n("Text and tab"), this),
  textAndTabText(this),
  textAndTabButton("...", this),
  timeSignatureLabel(i18n("Time signature"), this),
  timeSignatureText(this),
  timeSignatureButton("...", this),
  scoreLayout(this),
  titleLayout(this),
  subTitleLayout(this),
  textAndTabLayout(this),
  timeSignatureLayout(this)
{
	titleText.setText("Title");
	subTitleText.setText("Subtitle");
	textAndTabText.setText("Text and tab");
	timeSignatureText.setText("Time signature");
	
	titleText.setReadOnly(true);
	subTitleText.setReadOnly(true);
	textAndTabText.setReadOnly(true);
	timeSignatureText.setReadOnly(true);
	
	QFont titleFont(Settings::titleFont(), Settings::titleSize(), Settings::titleWeight(), Settings::titleItalic());
	QFont subTitleFont(Settings::subTitleFont(), Settings::subTitleSize(), Settings::subTitleWeight(), Settings::subTitleItalic());
	QFont textAndTabFont(Settings::textAndTabFont(), Settings::textAndTabSize(), Settings::textAndTabWeight(), Settings::textAndTabItalic());
	QFont timeSignatureFont(Settings::timeSignatureFont(), Settings::timeSignatureSize(), Settings::timeSignatureWeight(), Settings::timeSignatureItalic());
	
	titleText.setFont(titleFont);
	subTitleText.setFont(subTitleFont);
	textAndTabText.setFont(textAndTabFont);
	timeSignatureText.setFont(timeSignatureFont);
	
	titleLayout.addWidget(&titleLabel);
	titleLayout.addWidget(&titleText);
	titleLayout.addWidget(&titleButton);
	
	subTitleLayout.addWidget(&subTitleLabel);
	subTitleLayout.addWidget(&subTitleText);
	subTitleLayout.addWidget(&subTitleButton);
	
	textAndTabLayout.addWidget(&textAndTabLabel);
	textAndTabLayout.addWidget(&textAndTabText);
	textAndTabLayout.addWidget(&textAndTabButton);
	
	timeSignatureLayout.addWidget(&timeSignatureLabel);
	timeSignatureLayout.addWidget(&timeSignatureText);
	timeSignatureLayout.addWidget(&timeSignatureButton);
	
	scoreLayout.addLayout(&titleLayout);
	scoreLayout.addLayout(&subTitleLayout);
	scoreLayout.addLayout(&textAndTabLayout);
	scoreLayout.addLayout(&timeSignatureLayout);
	
	connect(&titleButton, SIGNAL(clicked()), SLOT(title()));
	connect(&subTitleButton, SIGNAL(clicked()), SLOT(subTitle()));
	connect(&textAndTabButton, SIGNAL(clicked()), SLOT(textAndTab()));
	connect(&timeSignatureButton, SIGNAL(clicked()), SLOT(timeSignature()));
}

void OptionsScore::defaultBtnClicked()
{
}

void OptionsScore::applyBtnClicked()
{
	config->setGroup("Font");
	
	config->writeEntry("titleFont", titleText.font().family());
	config->writeEntry("titleWeight", titleText.font().weight());
	config->writeEntry("titleItalic", titleText.font().italic());
	config->writeEntry("titeSize", titleText.font().pointSize());
	
	config->writeEntry("subTitleFont", subTitleText.font().family());
	config->writeEntry("subTitleWeight", subTitleText.font().weight());
	config->writeEntry("subTitleItalic", subTitleText.font().italic());
	config->writeEntry("subTitleSize", subTitleText.font().pointSize());
	
	config->writeEntry("textAndTabFont", textAndTabText.font().family());
	config->writeEntry("textAndTabWeight", textAndTabText.font().weight());
	config->writeEntry("textAndTabItalic", textAndTabText.font().italic());
	config->writeEntry("textAndTabSize", textAndTabText.font().pointSize());
	
	config->writeEntry("timeSignatureFont", timeSignatureText.font().family());
	config->writeEntry("timeSignatureWeight", timeSignatureText.font().weight());
	config->writeEntry("timeSignatureItalic", timeSignatureText.font().italic());
	config->writeEntry("timeSignatureSize", timeSignatureText.font().pointSize());
}

void OptionsScore::title()
{
	bool ok;
	
	QFont font = QFontDialog::getFont(&ok);
	
	if (ok) {
		titleText.setFont(font);
	}
}

void OptionsScore::subTitle()
{
	bool ok;
	
	QFont font = QFontDialog::getFont(&ok);
	
	if (ok) {
		subTitleText.setFont(font);
	}
}

void OptionsScore::textAndTab()
{
	bool ok;
	
	QFont font = QFontDialog::getFont(&ok);
	
	if (ok) {
		textAndTabText.setFont(font);
	}
}

void OptionsScore::timeSignature()
{
	bool ok;
	
	QFont font = QFontDialog::getFont(&ok);
	
	if (ok) {
		timeSignatureText.setFont(font);
	}
}
