/***************************************************************************
 * optionsmidi.cpp: implementation of OptionsTimidity class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#include "optionstimidity.h"
#include "settings.h"

OptionsTimidity::OptionsTimidity(KConfig *conf, QWidget *parent, const char *name)
: OptionsPage(conf, parent, name),timidityPathLabel(i18n("Timidity path"), this), timidityPath(this), timidityButton("...", this),
  bufferLabel(i18n("Buffer"), this), buffer(0, 10, 1, this), fragmentLabel(i18n("Fragment"), this), fragment(0, 10, 1,this),
  outputLabel(i18n("Output"), this), output(this), chorusLabel(i18n("Chorus"), this), chorus(this),
  delayLabel(i18n("Delay"), this), delay(this), reverbLabel(i18n("Reverb"), this), reverb(this),
  vlpfLabel(i18n("Voice LPF effect"), this), vlpf(this), noiseLabel(i18n("Noise shaping"), this), noise(this),
  resampLabel(i18n("Resample"), this), resamp(this), frequencyLabel(i18n("Resampling frequency"), this), frequency(0, 44100, 1000, this),
  realtimeEnableLabel(i18n("Realtime priority enable"), this), realtimeEnable(this),
  realtimeLabel(i18n("Realtime priority"), this), realtime(0, 100, 10, this), timidityLayout(this)
{
	timidityPathLayout.addWidget(&timidityPathLabel);
	timidityPathLayout.addWidget(&timidityPath);
	timidityPathLayout.addWidget(&timidityButton);
	
	bufferLayout.addWidget(&bufferLabel);
	bufferLayout.addWidget(&buffer);
	
	fragmentLayout.addWidget(&fragmentLabel);
	fragmentLayout.addWidget(&fragment);
	
	outputLayout.addWidget(&outputLabel);
	outputLayout.addWidget(&output);
	
	output.insertItem("Default");
	output.insertItem("ALSA");
	output.insertItem("EsounD");
	output.insertItem("JACK");
	output.insertItem("aRts");
	
	chorusLayout.addWidget(&chorusLabel);
	chorusLayout.addWidget(&chorus);
	
	chorus.insertItem("Disable this effect");
	chorus.insertItem("Enable MIDI chorus effect control.");
	chorus.insertItem("Surround  sound, chorus detuned to a lesser degree (default).");
	
	delayLayout.addWidget(&delayLabel);
	delayLayout.addWidget(&delay);
	
	delay.insertItem("Disable delay effect.");
	delay.insertItem("Left delay.");
	delay.insertItem("Right delay.");
	delay.insertItem("Swap left & right.");
	
	reverbLayout.addWidget(&reverbLabel);
	reverbLayout.addWidget(&reverb);
	
	reverb.insertItem("Disable MIDI reverb effect control.");
	reverb.insertItem("Enable  MIDI  reverb  effect control. This effect is only available in stereo.");
	reverb.insertItem("Global reverb effect.");
	reverb.insertItem("Freeverb MIDI reverb effect control (default).");
	reverb.insertItem("Global freeverb effect.");
	
	vlpfLayout.addWidget(&vlpfLabel);
	vlpfLayout.addWidget(&vlpf);
	
	vlpf.insertItem("Disable LPF effect.");
	vlpf.insertItem("Chamberlin resonant LPF (12dB/oct) (default).");
	vlpf.insertItem("Moog resonant low-pass VCF (24dB/oct).");
	
	noiseLayout.addWidget(&noiseLabel);
	noiseLayout.addWidget(&noise);
	
	noise.insertItem("No noise shaping.");
	noise.insertItem("Traditional noise shaping.");
	noise.insertItem("Overdrive-like soft-clipping + new noise shaping.");
	noise.insertItem("Tube-amplifier-like soft-clipping + new noise shaping.");
	noise.insertItem("New noise shaping.");
	
	resampLayout.addWidget(&resampLabel);
	resampLayout.addWidget(&resamp);
	
	resamp.insertItem("No interpolation.");
	resamp.insertItem("Linear interpolation.");
	resamp.insertItem("Cubic spline interpolation.");
	resamp.insertItem("Lagrange method.");
	resamp.insertItem("Newton polynomial interpolation.");
	resamp.insertItem("Modified Gauss effect (default).");
	
	frequencyLayout.addWidget(&frequencyLabel);
	frequencyLayout.addWidget(&frequency);
	
	realtimeEnableLayout.addWidget(&realtimeEnableLabel);
	realtimeEnableLayout.addWidget(&realtimeEnable);
	
	realtimeLayout.addWidget(&realtimeLabel);
	realtimeLayout.addWidget(&realtime);

	timidityLayout.addLayout(&timidityPathLayout);
	timidityLayout.addLayout(&bufferLayout);
	timidityLayout.addLayout(&fragmentLayout);
	timidityLayout.addLayout(&outputLayout);
	timidityLayout.addLayout(&chorusLayout);
	timidityLayout.addLayout(&delayLayout);
	timidityLayout.addLayout(&reverbLayout);
	timidityLayout.addLayout(&vlpfLayout);
	timidityLayout.addLayout(&noiseLayout);
	timidityLayout.addLayout(&resampLayout);
	timidityLayout.addLayout(&frequencyLayout);
	timidityLayout.addLayout(&realtimeEnableLayout);
	timidityLayout.addLayout(&realtimeLayout);
	
	fillOptions();
	
	connect(&timidityButton, SIGNAL(clicked()), SLOT(search()));
}

void OptionsTimidity::defaultBtnClicked()
{
}

void OptionsTimidity::applyBtnClicked()
{
	config->setGroup("Timidity");
	
	config->writeEntry("Path", timidityPath.text());
	
	config->writeEntry("Buffer", buffer.value());
	
	config->writeEntry("Fragment", fragment.value());
	
	switch(output.currentItem()) {
		case 0:
			config->writeEntry("Output", "d");
			break;
		case 1:
			config->writeEntry("Output", "s");
			break;
		case 2:
			config->writeEntry("Output", "e");
			break;
		case 3:
			config->writeEntry("Output", "j");
			break;
		case 4:
			config->writeEntry("Output", "r");
			break;
	}
	
	switch(chorus.currentItem()) {
		case 0:
			config->writeEntry("Chorus", "d");
			break;
		case 1:
			config->writeEntry("Chorus", "n");
			break;
		case 2:
			config->writeEntry("Chorus", "s");
			break;
	}
	
	switch(delay.currentItem()) {
		case 0:
			config->writeEntry("Delay", "d");
			break;
		case 1:
			config->writeEntry("Delay", "l");
			break;
		case 2:
			config->writeEntry("Delay", "r");
			break;
		case 3:
			config->writeEntry("Delay", "b");
			break;
	}
	
	switch(reverb.currentItem()) {
		case 0:
			config->writeEntry("Reverb", "d");
			break;
		case 1:
			config->writeEntry("Reverb", "n");
			break;
		case 2:
			config->writeEntry("Reverb", "g");
			break;
		case 3:
			config->writeEntry("Reverb", "f");
			break;
		case 4:
			config->writeEntry("Reverb", "G");
			break;
	}
	
	switch(vlpf.currentItem()) {
		case 0:
			config->writeEntry("Vlpf", "d");
			break;
		case 1:
			config->writeEntry("Vlpf", "c");
			break;
		case 2:
			config->writeEntry("Vlpf", "m");
			break;
	}
	
	
	config->writeEntry("Noise", noise.currentItem());
	
	switch(resamp.currentItem()) {
		case 0:
			config->writeEntry("Resample", "d");
			break;
		case 1:
			config->writeEntry("Resample", "l");
			break;
		case 2:
			config->writeEntry("Resample", "c");
			break;
		case 3:
			config->writeEntry("Resample", "L");
			break;
		case 4:
			config->writeEntry("Resample", "n");
			break;
		case 5:
			config->writeEntry("Resample", "G");
			break;
	}
	
	config->writeEntry("Frequency", frequency.value());
	
	config->writeEntry("RealTime", realtime.value());
	
	config->writeEntry("RealTimeEnable", realtimeEnable.isChecked());
}

void OptionsTimidity::search()
{
	QString temp = QFileDialog::getOpenFileName(timidityPath.text(), "timidity", this, "open file dialog", "Choose timidity" );
	
	if (!temp.isEmpty()) {
		timidityPath.setText(temp);
	}
}

void OptionsTimidity::fillOptions()
{
	timidityPath.setText(Settings::timidityPath());
	buffer.setValue(Settings::timidityBuffer());
	fragment.setValue(Settings::timidityFragment());
	
	switch(Settings::timidityOutput().ascii()[0]) {
		case 'd':
			output.setCurrentItem(0);
			break;
		case 's':
			output.setCurrentItem(1);
			break;
		case 'e':
			output.setCurrentItem(2);
			break;
		case 'j':
			output.setCurrentItem(3);
			break;
		case 'r':
			output.setCurrentItem(4);
			break;
		default:
			output.setCurrentItem(1);
	}
	
	switch(Settings::timidityChorus().ascii()[0]) {
		case 'd':
			chorus.setCurrentItem(0);
			break;
		case 'n':
			chorus.setCurrentItem(1);
			break;
		case 's':
			chorus.setCurrentItem(2);
			break;
		default:
			chorus.setCurrentItem(0);
	}
	
	switch(Settings::timidityDelay().ascii()[0]) {
		case 'd':
			delay.setCurrentItem(0);
			break;
		case 'l':
			delay.setCurrentItem(1);
			break;
		case 'r':
			delay.setCurrentItem(2);
			break;
		case 'b':
			delay.setCurrentItem(3);
			break;
		default:
			delay.setCurrentItem(0);
	}
	
	switch(Settings::timidityReverb().ascii()[0]) {
		case 'd':
			reverb.setCurrentItem(0);
			break;
		case 'n':
			reverb.setCurrentItem(1);
			break;
		case 'g':
			reverb.setCurrentItem(2);
			break;
		case 'f':
			reverb.setCurrentItem(3);
			break;
		case 'G':
			reverb.setCurrentItem(4);
			break;
		default:
			reverb.setCurrentItem(0);
	}
	
	switch(Settings::timidityVlpf().ascii()[0]) {
		case 'd':
			vlpf.setCurrentItem(0);
			break;
		case 'c':
			vlpf.setCurrentItem(1);
			break;
		case 'm':
			vlpf.setCurrentItem(2);
			break;
		default:
			vlpf.setCurrentItem(0);
	}
	
	
	noise.setCurrentItem(Settings::timidityNoise());
	
	switch(Settings::timidityResamp().ascii()[0]) {
		case 'd':
			resamp.setCurrentItem(0);
			break;
		case 'l':
			resamp.setCurrentItem(1);
			break;
		case 'c':
			resamp.setCurrentItem(2);
			break;
		case 'L':
			resamp.setCurrentItem(3);
			break;
		case 'n':
			resamp.setCurrentItem(4);
			break;
		case 'G':
			resamp.setCurrentItem(5);
			break;
		default:
			resamp.setCurrentItem(1);
	}
	
	frequency.setValue(Settings::timidityFrequency());
	
	realtime.setValue(Settings::timidityRealTime());
	
	realtimeEnable.setChecked(Settings::timidityRealTimeEnable());
}
