/***************************************************************************
 * settabfret.h: implementation of SetTabFret class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef SETTABFRET_H
#define SETTABFRET_H

#include <header.h>

#include "radiustuner.h"
#include "global.h"

/*!
	TODO
*/
class SetTabFret: public QWidget {
    Q_OBJECT
public:
	/*!
		TODO
	*/
	SetTabFret(QWidget *parent=0, const char *name=0);
	
	/*!
		TODO
	*/
	void setString(int n) { st->setValue(n); };
	
	/*!
		TODO
	*/
	void setFrets(int n) { fr->setValue(n); };
	
	/*!
		TODO
	*/
	void setTune(uchar x, uchar n) { tuner[x]->setValue(n); };
	
	/*!
		TODO
	*/
	int string() { return st->value(); };
	
	/*!
		TODO
	*/
	int frets() { return fr->value(); };
	
	/*!
		TODO
	*/
	uchar tune(uchar x) { return tuner[x]->value(); };
	
public slots:
	/*!
		TODO
	*/
	void setLibTuning(int n);
	
	/*!
		TODO
	*/
	void stringChanged(int n);
	
	/*!
		TODO
	*/
	void tuneChanged();
	
private:
    virtual void resizeEvent(QResizeEvent *e);
    void reposTuners();

    QComboBox *lib;
    QSpinBox *st,*fr;
    RadiusTuner *tuner[MAX_STRINGS];
    int oldst;
};

#endif
