/***************************************************************************
 * settings.cpp: implementation of Settings class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#include "settings.h"


QString Settings::noteNames[9][12] = {
	{"C",  "C#", "D",  "D#", "E",  "F",	 "F#", "G",  "G#", "A",  "A#", "B"},
	{"C",  "Db", "D",  "Eb", "E",  "F",	 "Gb", "G",  "Ab", "A",  "Bb", "B"},
	{"C",  "Db", "D",  "Eb", "E",  "F",	 "F#", "G",  "G#", "A",  "Bb", "B"},
	{"C",  "C#", "D",  "D#", "E",  "F",	 "F#", "G",  "G#", "A",  "A#", "H"},
	{"C",  "Db", "D",  "Eb", "E",  "F",	 "Gb", "G",  "Ab", "A",  "Hb", "H"},
	{"C",  "Db", "D",  "Eb", "E",  "F",	 "F#", "G",  "G#", "A",  "Hb", "H"},
	{"C",  "C#", "D",  "D#", "E",  "F",	 "F#", "G",  "G#", "A",  "B" , "H"},
	{"C",  "Db", "D",  "Eb", "E",  "F",	 "Gb", "G",  "Ab", "A",  "B" , "H"},
	{"C",  "Db", "D",  "Eb", "E",  "F",	 "F#", "G",  "G#", "A",  "B" , "H"}
};

KConfig* Settings::config = NULL;

QString Settings::noteName(int num)
{
	if (num < 0 || num > 11)
		return i18n("Unknown");

	config->setGroup("General");
	int option = config->readNumEntry("NoteNames", 2);

	if (option < 0 || option > 8)
		option = 2;

	return noteNames[option][num];
}

QString Settings::maj7Name()
{
	config->setGroup("General");
	switch (config->readNumEntry("Maj7", 0)) {
	case 1: return "maj7";
	case 2: return "dom7";
	default: return "7M";
	}
}

QString Settings::flatName()
{
	config->setGroup("General");
	if (config->readNumEntry("FlatPlus", 0) == 1) {
		return "b";
	} else {
		return "-";
	}
}

QString Settings::sharpName()
{
	config->setGroup("General");
	if (config->readNumEntry("FlatPlus", 0) == 1) {
		return "#";
	} else {
		return "+";
	}
}

QString Settings::midiName()
{
	config->setGroup("MIDI");
	return config->readEntry("Name", 0);
}

QString Settings::midiPort()
{
	config->setGroup("MIDI");
	return config->readEntry("Port", "");
}

int Settings::midiPortNumber()
{
	config->setGroup("MIDI");
	return config->readNumEntry("PortNumber", 0);
}

bool Settings::midiReadable()
{
	config->setGroup("MIDI");
	return config->readBoolEntry("Readable", false);
}

bool Settings::midiWriteable()
{
	config->setGroup("MIDI");
	return config->readBoolEntry("Writeable", false);
}

bool Settings::midiTimidity()
{
    config->setGroup("MIDI");
	return config->readBoolEntry("Timidity", false);
}

int Settings::melodyEditorInlay()
{
    config->setGroup("MelodyEditor");
	return config->readNumEntry("Inlay", 1);
}

int Settings::melodyEditorAction(int num)
{
    config->setGroup("MelodyEditor");
	return config->readNumEntry(QString("Action%1").arg(num), 0);
}

bool Settings::melodyEditorAdvance(int num)
{
    config->setGroup("MelodyEditor");
	return config->readBoolEntry(QString("Advance%1").arg(num), FALSE);
}

int Settings::texTabSize()
{
    config->setGroup("MusiXTeX");
	return config->readNumEntry(QString("TabSize"), 2);
}

bool Settings::texShowBarNumber()
{
    config->setGroup("MusiXTeX");
	return config->readBoolEntry("ShowBarNumber", TRUE);
}

bool Settings::texShowStr()
{
    config->setGroup("MusiXTeX");
	return config->readBoolEntry("ShowStr", TRUE);
}

bool Settings::texShowPageNumber()
{
    config->setGroup("MusiXTeX");
	return config->readBoolEntry("ShowPageNumber", TRUE);
}

bool Settings::texExportMode()
{
    config->setGroup("MusiXTeX");
	return config->readNumEntry("ExportMode", 0);
}

int Settings::printingStyle()
{
    config->setGroup("Printing");
	return config->readNumEntry("Style", 0);
}

QString Settings::timidityPath()
{
	config->setGroup("Timidity");
	return config->readEntry("Path", "/usr/bin/timidity");
}

int Settings::timidityBuffer()
{
	config->setGroup("Timidity");
	return config->readNumEntry("Buffer", 2);
}

int Settings::timidityFragment()
{
	config->setGroup("Timidity");
	return config->readNumEntry("Fragment", 8);
}

QString Settings::timidityOutput()
{
	config->setGroup("Timidity");
	return config->readEntry("Output", "s");
}

QString Settings::timidityChorus()
{
	config->setGroup("Timidity");
	return config->readEntry("Chorus", "d");
}

QString Settings::timidityDelay()
{
	config->setGroup("Timidity");
	return config->readEntry("Delay", "d");
}

QString Settings::timidityReverb()
{
	config->setGroup("Timidity");
	return config->readEntry("Reverb", "d");
}

QString Settings::timidityVlpf()
{
	config->setGroup("Timidity");
	return config->readEntry("Vlpf", "d");
}

int Settings::timidityNoise()
{
	config->setGroup("Timidity");
	return config->readNumEntry("Noise", 0);
}

QString Settings::timidityResamp()
{
	config->setGroup("Timidity");
	return config->readEntry("Resample", "l");
}

int Settings::timidityFrequency()
{
	config->setGroup("Timidity");
	return config->readNumEntry("Frequency", 44100);
}

bool Settings::timidityRealTimeEnable()
{
	config->setGroup("Timidity");
	return config->readBoolEntry("RealTimeEnable", false);
}

int Settings::timidityRealTime()
{
	config->setGroup("Timidity");
	return config->readNumEntry("RealTime", 50);
}

bool Settings::assistant()
{
	config->setGroup("Assistant");
	return config->readBoolEntry("FirstTime", false);
}

QString Settings::titleFont()
{
	config->setGroup("Font");
	return config->readEntry("titleFont", "Bitstream Vera Sans");
}

QFont::Weight Settings::titleWeight()
{
	config->setGroup("Font");
	return static_cast<QFont::Weight>(config->readNumEntry("titleWeight", 50));
}

bool Settings::titleItalic()
{
	config->setGroup("Font");
	return config->readBoolEntry("titleItalic", false);
}

int Settings::titleSize()
{
	config->setGroup("Font");
	return config->readNumEntry("titeSize", 28);
}

QString Settings::subTitleFont()
{
	config->setGroup("Font");
	return config->readEntry("subTitleFont", "Bitstream Vera Sans");
}

QFont::Weight Settings::subTitleWeight()
{
	config->setGroup("Font");
	return static_cast<QFont::Weight>(config->readNumEntry("subTitleWeight", 50));
}

bool Settings::subTitleItalic()
{
	config->setGroup("Font");
	return config->readBoolEntry("subTitleItalic", false);
}

int Settings::subTitleSize()
{
	config->setGroup("Font");
	return config->readNumEntry("subTitleSize", 24);
}

QString Settings::textAndTabFont()
{
	config->setGroup("Font");
	return config->readEntry("textAndTabFont", "Bitstream Vera Sans");
}

QFont::Weight Settings::textAndTabWeight()
{
	config->setGroup("Font");
	return static_cast<QFont::Weight>(config->readNumEntry("textAndTabWeight", 50));
}

bool Settings::textAndTabItalic()
{
	config->setGroup("Font");
	return config->readBoolEntry("textAndTabItalic", false);
}

int Settings::textAndTabSize()
{
	config->setGroup("Font");
	return config->readNumEntry("textAndTabSize", 9);
}

QString Settings::timeSignatureFont()
{
	config->setGroup("Font");
	return config->readEntry("timeSignatureFont", "Bitstream Vera Sans");
}

QFont::Weight Settings::timeSignatureWeight()
{
	config->setGroup("Font");
	return static_cast<QFont::Weight>(config->readNumEntry("timeSignatureWeight", 75));
}

bool Settings::timeSignatureItalic()
{
	config->setGroup("Font");
	return config->readBoolEntry("timeSignatureItalic", false);
}

int Settings::timeSignatureSize()
{
	config->setGroup("Font");
	return config->readNumEntry("timeSignatureFont", 14);
}
