/***************************************************************************
 * settrack.cpp: implementation of SetTrack class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#include "settrack.h"
#include "settabfret.h"
#include "settabdrum.h"

#include "tablature/trackproperties.h"

SetTrack::SetTrack(const TabTrack& track, TabSong& song, QWidget *parent, const char *name)
: QTabDialog(parent, name, TRUE), tabTrack(track), tabSong(song), trackMode(tabTrack.mode())
{
    //////////////////////////////////////////////////////////////////
    // GENERAL CONTROLS TAB
    //////////////////////////////////////////////////////////////////
	
	QWidget *gen = new QWidget(this);
	QGridLayout *g = new QGridLayout(gen, 5, 2, 10);
	
	title = new QLineEdit(gen);
	channel = new KIntNumInput(gen);
	bank = new KIntNumInput(gen);
	
	patch = new QComboBox(FALSE, gen);
	patch->insertStringList(instruments.getInstrumentList());
	
	mode = new QComboBox(FALSE, gen);
	mode->insertItem(i18n("Fretted instrument"));
	mode->insertItem(i18n("Drum track"));

	QLabel *title_l = new QLabel(title, i18n("&Track name:"), gen);
	QLabel *channel_l = new QLabel(bank, i18n("&Channel:"), gen);
	QLabel *bank_l = new QLabel(bank, i18n("&Bank:"), gen);
	QLabel *patch_l = new QLabel(patch, i18n("&Patch:"), gen);
	QLabel *mode_l = new QLabel(mode, i18n("&Mode:"), gen);

	g->addWidget(title_l, 0, 0);
	g->addWidget(title, 0, 1);
	g->addWidget(channel_l, 1, 0);
	g->addWidget(channel, 1, 1);
	g->addWidget(bank_l, 2, 0);
	g->addWidget(bank, 2, 1);
	g->addWidget(patch_l, 3, 0);
	g->addWidget(patch, 3, 1);
	g->addWidget(mode_l, 4, 0);
	g->addWidget(mode, 4, 1);

	for (int i = 0; i < 4; i++)
		g->addRowSpacing(i, 20);

	g->addColSpacing(0, 80);
	g->setColStretch(1, 1);
	g->activate();

	// Fill tab with information

	title->setText(tabTrack.name());
	//	title->setReadOnly(isBrowserView);
	channel->setValue(tabTrack.channel());
	//	channel->setDisabled(isBrowserView);
	bank->setValue(tabTrack.bank());
	//	bank->setDisabled(isBrowserView);
// 	patch->setValue(tabTrack.getPatch());
	patch->setCurrentItem(tabTrack.patch());
	//	patch->setDisabled(isBrowserView);
	mode->setCurrentItem(tabTrack.mode());
	//	mode->setDisabled(isBrowserView);
	connect(mode, SIGNAL(highlighted(int)), SLOT(selectTrackMode(int)));

// 	tabTrack. = trk;

	addTab(gen, i18n("&General"));
	
	kdDebug() << "tabtrack : " << tabTrack.nbStrings() << "\n";
	
    //////////////////////////////////////////////////////////////////
    // TAB MIDI SPECIFIC WIDGET
    //////////////////////////////////////////////////////////////////

	QWidget *tabmidiPage = new SetTabMidi(this);
	addTab(tabmidiPage, i18n("MIDI &effects"));

	tabmidi = (SetTabMidi *) tabmidiPage;
	//ToDo: set values from tabTrack.
	tabmidi->setVolume(track.volume());
	tabmidi->setPan(track.balance() - 8);
	tabmidi->setReverb(track.reverb());
	tabmidi->setChorus(track.chorus());
	tabmidi->setTranspose(0);
    //////////////////////////////////////////////////////////////////
    // TAB MODE SPECIFIC WIDGET
    //////////////////////////////////////////////////////////////////

	modespec = new SetTabFret(this);
	addTab(modespec, i18n("&Mode-specific"));

	// Fill tab with information
	selectTrackMode(tabTrack.mode());

	// Buttons

	setOkButton(i18n("OK"));
	setCancelButton(i18n("Cancel"));

	setCaption(i18n("Track properties"));
}

void SetTrack::selectTrackMode(int sel)
{
	switch ((TrackMode) sel) {
	case FretTab: selectFret(); break;
	case DrumTab: selectDrum(); break;
	}
}

void SetTrack::selectFret()
{
	removePage(modespec);
	modespec = new SetTabFret(this);
	addTab(modespec, i18n("&Mode-specific"));
	SetTabFret *fret = (SetTabFret *) modespec;
	
	fret->setString(tabTrack.nbStrings());
	fret->setFrets(tabTrack.nbFrets());
	for (int i = 0; i < tabTrack.nbStrings(); i++)
		fret->setTune(i, tabTrack.tune(i));
	//	fret->setDisabled(isBrowserView);
}

void SetTrack::selectDrum()
{
	if (trackMode != DrumTab) {
		// Check if there is a drum track
		//
		for (uint i = 0; i < tabSong.count(); i++) {
			if (tabSong.at(i)->mode() == DrumTab) {
				KMessageBox::error(0, "There is a drum track, you can only have one drum track");
				return ;
			}
			
		}
	}
	
	removePage(modespec);
	modespec = new SetTabDrum(this);
	addTab(modespec, i18n("&Mode-specific"));
	SetTabDrum *drum = (SetTabDrum *) modespec;

	drum->setDrums(tabTrack.nbStrings());
	
	for (int i = 0; i < tabTrack.nbStrings(); i++)
		drum->setTune(i, tabTrack.tune(i));
}
