/***************************************************************************
 * settrack.h: implementation of SetTrack class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef SETTRACK_H
#define SETTRACK_H

#include <header.h>

#include "global.h"
#include "tabtrack.h"
#include "tablature/tabsong.h"
#include "../sequencer/instruments.h"

#include "settabmidi.h"

class SetTabFret;
class SetTabDrum;
// class SetTabMidi;
class TabTrack;

/*!
	TODO PRIVATE !!!!
*/
class SetTrack: public QTabDialog {
    Q_OBJECT
public:
	/*!
		TODO
	*/
	SetTrack(const TabTrack& track, TabSong& song, QWidget *parent = 0, const char *name = 0);
	
	QLineEdit *title;
// 	KIntNumInput *channel, *bank, *patch;
	KIntNumInput *channel, *bank;
	QComboBox *mode, *patch;
	QWidget *modespec;
	const TabTrack& tabTrack;
	SetTabMidi* tabmidi;
public slots:
	/*!
		TODO
	*/
	void selectTrackMode(int sel);
	
private:
	void selectFret();
	void selectDrum();
	
	InstrumentsList instruments;
	TabSong& tabSong;
	TrackMode trackMode;
};

#endif
