/***************************************************************************
 * songview.h: implementation of SongView class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef SONGVIEW_H
#define SONGVIEW_H

#include <header.h>

#include "config.h"
#include "global.h"
#include "tabsong.h"

class MelodyEditor;
class PlaybackTracker;
class SequencerAlsa;
class SongPrint;
class TabSongPlayer;
class TabTrack;
class TrackEditView;
class TrackList;
class TrackPane;
class TrackPos;

/*!
	Stores with TabSong a song in memory, inits the menus, the menubar, 
	and the main widget.
*/
class SongView: public QWidget, public TabSong {
	Q_OBJECT
public:
	/*!
		Inits the default actions and the main widget.
		\param parentAction inits the action collection.
		\param _XMLGUIClient needed by TrackView and TrackList.
		\param _cmdHist used for the undo, redo actions.
		\param parent the parent widget.
		\param name of the widget.
	*/
	SongView(TSE3::MidiScheduler* midiScheduler, KActionCollection* parentAction, KXMLGUIClient* _XMLGUIClient, KCommandHistory* _cmdHist,
			 QWidget* parent=0, const char* name=0);
	
	/*
		Free memory.
	*/
	virtual ~SongView();
	
	/*
		Refreshes all the views and resets all minor parameters in the
		song. Should be called every time when the song's just got loaded
		or imported.
	*/
	void refreshView();
	
	/*
		Print the song.
		\param printer the printer.
	*/
	void print(KPrinter* printer);
	
	/*
		Send a drawBackground message to the MelodyEditor class.
	*/
	void drawBackground();
	
	/*
		Show the MelodyEditor.
		\param i show or hide the MeoldyEditor.
	*/
	void showMelodyEditor(bool i);
	
	/*
		Show the score.
		\param i show or hide the TrackView score.
	*/
	void viewScore(bool i);
	
	const TrackEditView* getTrackEditView() const;
	
	inline void setMidiScheduler(TSE3::MidiScheduler* midiScheduler)
	{ scheduler = midiScheduler; }
	
	// Forwards declarations of all undo/redo commands
	//
	class AddTrackCommand;
	class DeleteTrackCommand;
	class SetSongPropCommand;
	class SetTrackPropCommand;
	class InsertTabsCommand;
	
signals:
	void statusBar(const QString& msg);
	
public slots:
	/*!
		Creates a new track in the song.
		\return false when the user undo the creation of the track.
	*/
	bool trackNew();
	
	/*!
		Deletes the currently selected track in the song.
	*/
	void trackDelete();
	
	/*!
		Sets current track's properties.
		\return false when the user undo the modifications.
	*/
	bool trackProperties();
	
	/*!
		Generates a new track with a basic bass line, derived from current
		track's rhythm.
	*/
	void trackBassLine();
	
	/*!
		Dialog to set song's properties.
	*/
	void songProperties();
	
	/*!
		Start playing the song or stop it if it already plays.
	*/
	void playSong();
	
	/*!
		Stop playing the song.
	*/
	void stopPlay();
	
	/*!
		TODO
	*/
	void slotCut();
	
	/*!
		TODO
	*/
	void slotCopy();
	
	/*!
		TODO
	*/
	void slotPaste();
	
	/*!
		TODO
	*/
	void slotSelectAll();
	
	/*!
		TODO
	*/
	void setReadOnly(bool _ro) { ro = _ro; };
	
	/*!
		Move the cursor to the position and refresh the view.
	*/
	void playbackCursor(int track, const TrackPos& position);
	
signals:
	/*!
		TODO
	*/
	void songChanged();
	
private:
	// The QCanvas class provides a 2D area that can contain QCanvasItem objects.
	// The QCanvasItem are the tile, subtitle, bars, ...
	//
	QCanvas* canvas;
	
	SongPrint* songPrint;
	TrackEditView* trackEditView;
	TrackList* trackList;
	TrackPane* trackPane;
	MelodyEditor* melodyEditor;
	
	TabTrack *highlightedTabs();
	void insertTabs(TabTrack& tempTrack);
	
	// Set track properties
	//
	bool setTrackProperties(TabTrack& track);
	
	QSplitter *split, *splitv;
	QBoxLayout *layout;
	KCommandHistory *cmdHist;
	
	bool ro;
	
	// MIDI stuff
	bool midiInUse, midiStopPlay;
	
	KActionCollection *actionCollection;
	
	KAction *preferencesAct, *confTBAct, *browserAct, *sngPropAct,
		*trkNewAct, *trkDeleteAct, *trkBassLineAct, *trkPropAct, *insChordAct,
		*len1Act, *len2Act, *len4Act, *len8Act, *len16Act, *len32Act,
		*keySigAct, *timeSigAct, *arcAct, *legatoAct, *natHarmAct, *artHarmAct,
		*palmMuteAct, *slideAct, *letRingAct, *saveOptionAct, *confKeyAct,
		*arrTrkAct, *midiPlaySongAct, *midiStopPlayAct, *rhythmerAct,
		*pasteAct, *tripletAct, *insertBarAct, *deleteBarAct, *halfBendAct,
		*fullBendAct, *halfBendReleaseAct, *fullBendReleaseAct,
		*halfPreBendAct, *fullPreBendAct, *halfPreBendRelease, *fullPreBendRelease, *unisonBend,
		*vibratoAct, *wideVibratoAct, *trillAct, *tappingAct, *tremoloBarAct, *muffledStringsAct,
		*pickSlideAct, *tremoloPickingAct;
	
	KToggleAction *showMainTBAct, *showEditTBAct, *viewMelodyEditorAct, *viewScoreAct, *lenDottedAct, *lenRestAct;
	
	KAccel *mainAccel;
	
	KWidgetAction* nTupletsAct;
	
	QComboBox* ntuplets;
	
	TSE3::MidiScheduler* scheduler;
	
	TabSongPlayer* tabSong;
	
	PlaybackTracker* playbackTracker;
};

#endif
