/***************************************************************************
 * songviewcommands.h: implementation of SetSongPropCommand class
 *                                       SetTrackPropCommand
 *                                       InsertTabsCommand
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef SONGVIEWCOMMANDS_H
#define SONGVIEWCOMMANDS_H

#include <header.h>

#include "global.h"
#include "tabtrack.h"
#include "songview.h"

class TabTrack;
class TrackEditView;
class TrackList;
class TrackPane;
class SongView;

/*!
	Add a new track
*/
class SongView::AddTrackCommand: public KNamedCommand {
public:
	/*!
		TODO.
	*/
	AddTrackCommand(TabSong& tabSong, TabTrack& tabTrack, TrackEditView& tv, TrackList& list, TrackPane& pane);
		
	/*!
		TODO.
	*/
	virtual ~AddTrackCommand() {};
	
	/*!
		TODO.
	*/
	virtual void execute();
	
	/*!
		TODO.
	*/
	virtual void unexecute();

private:
	TabSong& newTabSong;
	TabTrack& oldTrack;
	TabTrack& newTrack;
	TrackEditView& trackView;
	TrackList& trackList;
	TrackPane& trackPane;
};

/*!
	Delete the selected track
*/
class SongView::DeleteTrackCommand: public KNamedCommand {
public:
	/*!
		TODO.
	*/
	DeleteTrackCommand(TabSong& tabSong, TrackEditView& tv, TrackList& list, TrackPane& pane);
		
	/*!
		TODO.
	*/
	virtual ~DeleteTrackCommand() {};
	
	/*!
		TODO.
	*/
	virtual void execute();
	
	/*!
		TODO.
	*/
	virtual void unexecute();

private:
	TabSong& newTabSong;
	TabTrack oldTrack;
	TrackEditView& trackView;
	TrackList& trackList;
	TrackPane& trackPane;
};

/*!
	Set the song properties
*/
class SongView::SetSongPropCommand: public KNamedCommand {
public:
	/*!
		TODO.
	*/
	SetSongPropCommand(SongView &, const TabProperties &);
	
	/*!
		TODO.
	*/
	virtual ~SetSongPropCommand() {};
	
	/*!
		TODO.
	*/
	virtual void execute();
	
	/*!
		TODO.
	*/
	virtual void unexecute();

private:
	SongView &song;
	TabProperties oldProperties, newProperties;
};

/*!
	Set track properties
*/
class SongView::SetTrackPropCommand: public KNamedCommand {
public:
	/*!
		TODO.
	*/
	SetTrackPropCommand(TrackEditView &, TrackList &, TrackPane &, TabTrack &, TabTrack &);
		
	/*!
		TODO.
	*/
	virtual ~SetTrackPropCommand() {};
	
	/*!
		TODO.
	*/
	virtual void execute();
	
	/*!
		TODO.
	*/
	virtual void unexecute();

private:
	TabTrack   oldTrack;
	TabTrack&  currentTrack;
	TabTrack   newTrack;
	TrackEditView& trackView;
	TrackList& trackList;
	TrackPane& trackPane;
	uint string;
};

/*!
	Insert tabs
*/
class SongView::InsertTabsCommand: public KNamedCommand {
public:
	/*!
		TODO.
	*/
	InsertTabsCommand(TrackEditView& tv, TabTrack& trk, TabTrack& tabs, uint bar);
	
	/*!
		TODO.
	*/
	virtual ~InsertTabsCommand() {};
	
	/*!
		TODO.
	*/
	virtual void execute();
	
	/*!
		TODO.
	*/
	virtual void unexecute();

private:
	uint barPosition;
	TabTrack& currentTrack,& tempTrack, oldTrack;
	TrackEditView& trackView;
};
#endif
