/***************************************************************************
 * tabbar.cpp: implementation of TabBar class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#include "tabbar.h"
#include <iostream>
using namespace std;

TabBar::TabBar()
: keysig(0)
{
}

TabBar::TabBar(unsigned char i, unsigned char j)
: keysig(0)
{
	setTimeSignature(0, i);
	setTimeSignature(1, j);
}

void TabBar::setKeySignature(uint i)
{
	keysig = i;
}

uint TabBar::keySignature() const
{
	return keysig;
}

unsigned int TabBar::count() const
{
	return tabTimes.count();
}

void TabBar::setTimes(unsigned int i, const TabTimes &tempTimes)
{
	tabTimes[i] = tempTimes;
}

TabTimes TabBar::times(unsigned int i) const
{
	if ((i + 1) > tabTimes.count())
		return TabTimes();

	return tabTimes[i];
}

void TabBar::insertTimes(const TabTimes &tempTimes)
{
	tabTimes.push_back(tempTimes);
}

void TabBar::deleteTimes(unsigned int i)
{
	unsigned int j = 0;
	
	for (QValueList<TabTimes>::iterator it = tabTimes.begin(); it != tabTimes.end(); ++it) {
		if (j++ == i) {
			tabTimes.remove(it);
			it = tabTimes.end();
		}
	}
}

bool TabBar::isFull() const
{
	bool full = true;
	float durationCount = 0;
	float time = 0.;
	unsigned int tuplet;
	
	for (unsigned int i = 0; i < tabTimes.count(); i++)
	{
		tuplet = tabTimes[i].nTuplet() + 1;
		
		time = tabTimes[i].duration();
		
		if (tabTimes[i].isDotted())
			time+=(time / 2.0);

		if (tuplet > 1)
			time*=2;
		
		durationCount+=(time / tuplet);
	}
	
	
	if (durationCount < timeSignature(0) * (Whole / timeSignature(1)))
			full = false;
	
	return full;
}

bool TabBar::isOverTaken() const
{
	return !isFull();
}
