/***************************************************************************
 * tabbar.h: implementation of TabBar class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef TABBAR_H
#define TABBAR_H

#include <header.h>

#include "tabmixtablechanges.h"
#include "tabtimes.h"
#include "tabbarproperties.h"

/*
	The class TabBar describes a bar and it properties.
*/
class TabBar : public TabMixTableChanges, public TabBarProperties {
public:
	/*
		Create a class  with a time signature 4/4 and add an empty note.
	*/
	TabBar();
	
	/*
		Create a class with a time signature time1/time2.
	*/
	TabBar(unsigned char i, unsigned char j);
	
	/*
		Set the key signature.
	*/
	void setKeySignature(uint i);
	
	/*
		Get the key signature.
	*/
	uint keySignature() const;
	
	/*
		Count the number of notes.
	*/
	unsigned int count() const;
	
	/*
		Set a note at the position i.
	*/
	void setTimes(unsigned int i, const TabTimes& tempTimes);
	
	/*
		Get a note at the position i.
	*/
	TabTimes times(unsigned int i) const;
	
	/*
		Add a new note at the end.
	*/
	void insertTimes(const TabTimes& tempTimes);
	
	/*
		Delete a note at the position i.
	*/
	void deleteTimes(unsigned int i);
	
	/*
		Count the time of all the notes and return true if it is full.
	*/
	bool isFull() const;
	
	/*
		Check if the bar is overtaken.
	*/
	bool isOverTaken() const;
	
private:
	uint keysig;
	
	QValueList<TabTimes> tabTimes;
};


#endif
