/***************************************************************************
 * tabbend.h: implementation of TabBend class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/
 
#ifndef __TABBEND__
#define __TABBEND__

#include <header.h>

#include "tabbendpoint.h"

class TabBend {
public:
	enum BendType {
		NoneBend,
		Bend,
		BendRelease,
		BendReleaseBend,
		PreBend,
		PreBendRelease,
		Dip,
		Dive,
		ReleaseUp,
		InvertedDip,
		Return,
		ReleaseDown
	};
	
	TabBend();
	
	void setBendType(TabBend::BendType b);
	TabBend::BendType bendType() const;
	
	void setBendValue(int i);
	int bendValue() const;
	QString bendValueToString() const;
	
	void setBendPoint(const QValueList<TabBendPoint>& p);
	const QValueList<TabBendPoint>& bendPoint() const;
private:
	TabBend::BendType bendTypeEffect;
	int bendValueEffect;
	QValueList<TabBendPoint> bendPointList;
};

#endif
