/***************************************************************************
 * tabchord.h: implementation of TabChord class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef TABCHORD_H
#define TABCHORD_H

#include <header.h>

class TabChord {
public:
	enum ExtentionChord {
		noneExtention,
		nine,
		eleven,
		thirteen
	};
	
	enum AugmentedDiminished {
		noneAugmentedDiminished,
		augmented,
		diminished
	};
	
	TabChord();
	
	void setName(const QString& s);
	QString name() const;
	
	void setSharp(bool b);
	bool isSharp() const;
	
	void setRoot(uchar c);
	uchar root() const;
	
	void setType(uchar c);
	uchar type() const;
	
	void setNineElevenThirteen(ExtentionChord c);
	ExtentionChord nineElevenThirteen() const;
	
	void setBass(uchar c);
	uchar bass() const;
	
	void setAugmentedDiminished(AugmentedDiminished a);
	AugmentedDiminished augmentedDiminished() const;
	
	void setAddedNote(uchar c);
	uchar addedNote() const;
	
	void setTonalityFive(uchar c);
	uchar tonalityFive() const;
	
	void setTonalityNine(uchar c);
	uchar tonalityNine() const;
	
	void setTonalityEleven(uchar c);
	uchar tonalityEleven() const;
	
	void setBaseFret(long l);
	long baseFret() const;
	
	void setFret(uchar c, long l);
	long fret(uchar c) const;
	
	void setNumBarres(uchar c);
	uchar numBarres() const;
	
	void setBarreFret(uchar c, uchar d);
	uchar barreFret(uchar c) const;
	
	void setBarreStart(uchar c, uchar d);
	uchar barreStart(uchar c) const;
	
	void setBarreEnd(uchar c, uchar d);
	uchar barreEnd(uchar c) const;
	
	void setFingering(uchar c, uchar d);
	uchar fingering(uchar c) const;
	
	void setShowDiagram(bool b);
	bool isShowDiagram() const;
private:
	QString nameChord;
	
	bool sharpChord;
	uchar rootChord;
	uchar typeChord;
	ExtentionChord nineElevenThirteenChord;
	uchar bassChord;
	AugmentedDiminished augmentedDiminishedChord;
	uchar addedNoteChord;
	uchar baseFretChord;
	
	uchar fiveChord;
	uchar nineChord;
	uchar elevenChord;
	long base;
	QValueVector<long> fretChord;
	uchar barres;
	QValueVector<uchar> barreFretChord;
	QValueVector<uchar> barreStartChord;
	QValueVector<uchar> barreEndChord;
	QValueVector<uchar> fingeringChord;
	
	bool showDiag;
};

#endif
