/***************************************************************************
 * tabgracenote.h: implementation of TabGraceNote class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/
 
#ifndef __TABGRACENOTE__
#define __TABGRACENOTE__

#include "tabdynamic.h"
#include "tabgracenotetransition.h"

class TabGraceNote {
public:
	TabGraceNote();
	
	void setGraceNoteDuration(int i);
	int graceNoteDuration() const;
	
	void setGraceNoteDynamic(Dynamic d);
	Dynamic graceNoteDynamic() const;
	
	void setGraceNoteFret(int i);
	int graceNoteFret() const;
	
	void setGraceNoteTransition(GraceNoteTransition g);
	GraceNoteTransition graceNoteTransition() const;
private:
	int durationGrace;
	Dynamic dynamicGrace;
	int fretGrace;
	GraceNoteTransition transition;
};

#endif
