/***************************************************************************
 * tabmixtablechanges.h: implementation of TabMixTableChanges class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef TABMIXTABLECHANGES_H
#define TABMIXTABLECHANGES_H

/*
	The class TabMixChanges describes a mix table change.
*/
class TabMixTableChanges
{
public:
	TabMixTableChanges();
	
	virtual void setInstrument(int i);
	virtual int instrument() const;
	
	virtual void setVolume(int i);
	virtual int volume() const;
	
	virtual void setBalance(int i);
	virtual int balance() const;
	
	virtual void setChorus(int i);
	virtual int chorus() const;
	
	virtual void setReverb(int i);
	virtual int reverb() const;
	
	virtual void setPhaser(int i);
	virtual int phaser() const;
	
	virtual void setTremolo(int i);
	virtual int tremolo() const;
	
	virtual void setTempo(int i);
	virtual int tempo() const;
private:
	int instrumentMix;
	int volumeMix;
	int balanceMix;
	int chorusMix;
	int reverbMix;
	int phaserMix;
	int tremoloMix;
	int tempoMix;
};

#endif
