#include "tabnote.h"

TabNote::TabNote()
: accentuated(false), dotted(false), ghostNote(false),
  tieNote(false), deadNote(false), hammerOnPullOff(false), isSlideNote(false), letRing(false),
  dynamicNote(NoneDynamic), fingeringLeftNote(NoneFingering), fingeringRightNote(NoneFingering),
  nTupletNote(0), fretNumber(0), durationNote(Quarter), emptyNote(true), tremolo(0), slideNote(NoneSlide),
  leftHandVibratoNote(false), palmMuteNote(false), staccato(false), harmonicNote(NoneHarmonic)
{
}

void TabNote::setFret(unsigned char c)
{
	emptyNote = false;
	
	fretNumber = c;
}

unsigned char TabNote::fret() const
{
	return fretNumber;
}

void TabNote::setEmpty(bool b)
{
	emptyNote = b;
}

bool TabNote::isEmpty() const
{
	return emptyNote;
}

void TabNote::setDuration(Duration c)
{
	durationNote = c;
}

Duration TabNote::duration() const
{
	return durationNote;
}

void TabNote::setNTuplet(unsigned char c)
{
	nTupletNote = c;
}

unsigned char TabNote::nTuplet() const
{
	return nTupletNote;
}

void TabNote::setAccentuated(bool b)
{
	accentuated = b;
}

bool TabNote::isAccentuated() const
{
	return accentuated;
}

void TabNote::setDotted(bool b)
{
	dotted = b;
}

bool TabNote::isDotted() const
{
	return dotted;
}

void TabNote::setGhostNote(bool b)
{
	ghostNote = b;
}

bool TabNote::isGhostNote() const
{
	return ghostNote;
}

void TabNote::setTieNote(bool b)
{
	tieNote = b;
}

bool TabNote::isTieNote() const
{
	return tieNote;
}

void TabNote::setDeadNote(bool b)
{
	emptyNote = !b;
	
	deadNote = b;
}

bool TabNote::isDeadNote() const
{
	return deadNote;
}

void TabNote::setHammerOnPullOff(bool b)
{
	hammerOnPullOff = b;
}

bool TabNote::isHammerOnPullOff() const
{
	return hammerOnPullOff;
}

void TabNote::setSlide(bool b)
{
	isSlideNote = b;
}

bool TabNote::isSlide() const
{
	return isSlideNote;
}

void TabNote::setLetRing(bool b)
{
	letRing = b;
}

bool TabNote::isLetRing() const
{
	return letRing;
}

void TabNote::setDynamic(Dynamic d)
{
	dynamicNote = d;
}

Dynamic TabNote::dynamic() const
{
	return dynamicNote;
}

void TabNote::setFingeringLeft(TabNote::Fingering f)
{
	fingeringLeftNote = f;
}

TabNote::Fingering TabNote::fingeringLeft() const
{
	return fingeringLeftNote;
}

void TabNote::setFingeringRight(TabNote::Fingering f)
{
	fingeringRightNote = f;
}

TabNote::Fingering TabNote::fingeringRight() const
{
	return fingeringRightNote;
}

void TabNote::setLeftHandVibrato(bool b)
{
	leftHandVibratoNote = b;
}

bool TabNote::isLeftHandVibrato() const
{
	return leftHandVibratoNote;
}

void TabNote::setPalmMute(bool b)
{
	palmMuteNote = b;
}

bool TabNote::isPalmMute() const
{
	return palmMuteNote;
}

void TabNote::setStaccato(bool b)
{
	staccato = b;
}

bool TabNote::isStaccato() const
{
	return staccato;
}

void TabNote::setSlide(Slide s)
{
	slideNote = s;
}

Slide TabNote::slide() const
{
	return slideNote;
}

void TabNote::setTremoloPicking(char c)
{
	tremolo = c;
}

char TabNote::tremoloPicking() const
{
	return tremolo;
}

void TabNote::setHarmonic(Harmonic h)
{
	harmonicNote = h;
}

Harmonic TabNote::harmonic() const
{
	return harmonicNote;
}
