/***************************************************************************
 * tabproperties.cpp: implementation of TabProperties class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#include "tabproperties.h"

TabProperties::TabProperties()
: shuffle(false), tempoProp(120), octaveProp(0)
{
}

TabProperties::~TabProperties()
{
}

void TabProperties::setTitle(const QString &s)
{
	titleProp = s;
}

QString TabProperties::title() const
{
	return titleProp;
}

void TabProperties::setSubTitle(const QString &s)
{
	subTitleProp = s;
}

QString TabProperties::subTitle() const
{
	return subTitleProp;
}

void TabProperties::setArtist(const QString &s)
{
	artistProp = s;
}

QString TabProperties::artist() const
{
	return artistProp;
}

void TabProperties::setAlbum(const QString &s)
{
	albumProp = s;
}

QString TabProperties::album() const
{
	return albumProp;
}

void TabProperties::setAuthor(const QString &s)
{
	authorProp = s;
}

QString TabProperties::author() const
{
	return authorProp;
}

void TabProperties::setCopyright(const QString &s)
{
	copyrightProp = s;
}

QString TabProperties::copyright() const
{
	return copyrightProp;
}

void TabProperties::setTranscriber(const QString &s)
{
	transcriberProp = s;
}

QString TabProperties::transcriber() const
{
	return transcriberProp;
}

void TabProperties::setInstructions(const QString &s)
{
	instructionsProp = s;
}

QString TabProperties::instructions() const
{
	return instructionsProp;
}

void TabProperties::setComments(const QString &s)
{
	commentsProp = s;
}

QString TabProperties::comments() const
{
	return commentsProp;
}

void TabProperties::setShuffle(bool i)
{
	shuffle = i;
}

bool TabProperties::isShuffle() const
{
	return shuffle;
}

void TabProperties::setTempo(unsigned int i)
{
	tempoProp = i;
}

unsigned int TabProperties::tempo() const
{
	return tempoProp;
}

void TabProperties::setOctave(int i)
{
	octaveProp = i;
}

int TabProperties::octave() const
{
	return octaveProp;
}
