/***************************************************************************
 * tabsong.h: implementation of TabSong class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef TABSONG_H
#define TABSONG_H

#include <header.h>

#include "tabtrack.h"
#include "tabproperties.h"

/*
	The class TabSong store all the tracks and the properties of
	the song.
 */
class TabSong : public QPtrList<TabTrack>, public TabProperties
{
public:
	/*
		Create a new song with a tempo and a title.
	*/
	TabSong(QString title, int tempo);
	
	/*
		Create an empty new song.
	*/
	TabSong();
	
	/*
		Return true if there is a drum track
	*/
	bool isDrumTrack();
	
	/*
		Return the number of the drum track.
		Return -1 if there is no drum track.
	*/
	int drumTrack();
};

#endif
