/***************************************************************************
 * tabnotes.cpp: implementation of TabTimes class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#include "tabtimes.h"

TabTimes::TabTimes()
: durationTimes(Quarter), dotted(false), rest(false), ntupletTimes(0),
  chord(false)
{
}

void TabTimes::setNotes(unsigned char i, TabNote n)
{
	notesTimes[i] = n;
}

TabNote TabTimes::notes(unsigned char i) const
{
	return notesTimes[i];
}

unsigned int TabTimes::count() const
{
	return notesTimes.count();
}

void TabTimes::setDuration(Duration i)
{
	durationTimes = i;
}

Duration TabTimes::duration() const
{
	return durationTimes;
}

double TabTimes::realDuration() const
{
	double duration = durationTimes;
	
	if (dotted == true)
		duration = duration + duration / 2.00;
	
	// For the triplet double time duration
	//
	if (ntupletTimes == 2)
		duration*=2;
	else if (ntupletTimes > 2 && ntupletTimes < 8)
		duration*=4;
	else if (ntupletTimes > 8 && ntupletTimes < 12)
		duration*=8;
	
	return duration / (ntupletTimes + 1.0);
}

void TabTimes::setRest(bool i)
{
	rest = i;
}

bool TabTimes::isRest() const
{
	return rest;
}

bool TabTimes::isEmpty() const
{
	bool checkDelete = false;
	QMap<unsigned char, TabNote>::ConstIterator it;
	
	for (it = notesTimes.begin(); it != notesTimes.end(); ++it) {
		if (it.data().isEmpty() == false) {
			checkDelete = true;
			break;
		}
	}
	
	return checkDelete;
}

void TabTimes::setDotted(bool i)
{
	dotted = i;
}

bool TabTimes::isDotted() const
{
	return dotted;
}

void TabTimes::setNTuplet(uint i)
{
	ntupletTimes = i;
}

uint TabTimes::nTuplet() const
{
	return ntupletTimes;
}

void TabTimes::setText(const QString& s)
{
	comment = s;
}

QString TabTimes::text() const
{
	return comment;
}

void TabTimes::setChord(bool b)
{
	chord = b;
}

bool TabTimes::isChord() const
{
	return chord;
}
