/***************************************************************************
 * tabtimes.h: implementation of TabTimes class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef TABNOTES_H
#define TABNOTES_H

#include <header.h>

#include "tabbeateffects.h"
#include "tabchord.h"
#include "tabduration.h"
#include "tabnote.h"

/*!
	TabTimes hold one note (may be a chord), the effects and the duration.
*/
class TabTimes : public TabBeatEffects, public TabChord {
public:
	TabTimes();
	
	void setNotes(unsigned char i, TabNote n);
	TabNote notes(unsigned char i) const;
	
	unsigned int count() const;
	
	void setDuration(Duration i);
	Duration duration() const;
	double realDuration() const;
	
	void setRest(bool i);
	bool isRest() const;
	
	bool isEmpty() const;
	
	void setDotted(bool i);
	bool isDotted() const;
	
	void setNTuplet(uint i);
	uint nTuplet() const;
	
	void setText(const QString& s);
	QString text() const;
	
	void setChord(bool b);
	bool isChord() const;
private:
	Duration durationTimes;
	bool dotted;
	bool rest;
	unsigned int ntupletTimes;
	QMap<unsigned char, TabNote> notesTimes;
	QString comment;
	bool chord;
};

#endif
