/***************************************************************************
 * trackproperties.cpp: implementation of TrackProperties class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#include "trackproperties.h"

TrackProperties::TrackProperties()
{
}

TrackProperties::TrackProperties(TrackMode mode, const QString& name, uchar channel, unsigned int bank, uchar patch, uchar strings, uchar frets)
:trackMode(mode), nameProp(name), nbStringsProp(strings), nbFretsProp(frets), tuneProp(strings)
{
	setChannel(channel);
	setBank(bank);
	setPatch(patch);
}

TrackProperties::~TrackProperties()
{
}

void TrackProperties::setMode(TrackMode mode)
{
	trackMode = mode;
}

TrackMode TrackProperties::mode() const
{
	return trackMode;
}

void TrackProperties::setName(const QString& string)
{
	nameProp = string;
}

QString TrackProperties::name() const
{
	return nameProp;
}

void TrackProperties::setColor(const QColor& c)
{
	colorTrack = c;
}

QColor TrackProperties::color() const
{
	return colorTrack;
}

void TrackProperties::setNbStrings(unsigned char i)
{
	tuneProp.resize(i);
	
	nbStringsProp = i;
}

unsigned char TrackProperties::nbStrings() const
{
	return nbStringsProp;
}

void TrackProperties::setNbFrets(unsigned char i)
{
	nbFretsProp = i;
}

unsigned char TrackProperties::nbFrets() const
{
	return nbFretsProp;
}

void TrackProperties::setTune(uchar i, uchar j)
{
	if (i > nbStringsProp)
		return;

	tuneProp[i] = j;
}

uchar TrackProperties::tune(uchar i) const
{
	if (i > nbStringsProp)
		return 0;

	return tuneProp[i];
}

void TrackProperties::setCapo(uchar c)
{
	if (c > nbFretsProp)
		return ;
	
	capoFret = c;
}

uchar TrackProperties::capo() const
{
	return capoFret;
}
