/***************************************************************************
 * trackbarlineview.h: implementation of TrackBarLineView class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef TRACKBARLINEVIEW_H
#define TRACKBARLINEVIEW_H

#include <header.h>

#include "unit.h"

class TrackBarLineView : public Unit
{
public:
	TrackBarLineView(uint strings, uint height, int resolutionDPI, QCanvas* canvas);
	~TrackBarLineView();

	// Draw the lines at the position with a length barWidth
	//
	void draw(const QPoint& position, uint barWidth);
	
	// Height of the lines
	//
	inline uint height() const
	{ return (nbStrings - 1) *  lineSpaces; }
	
	// Space between twe lines
	//
	inline uint lineSpace() const
	{ return lineSpaces; }

private:
	const uint nbStrings;
	const uint lineSpaces;
	QCanvas* canvasView;
	QCanvasLine** line;
};

#endif
