#include "trackclassicalclefview.h"

TrackClassicalClefView::TrackClassicalClefView(int resolutionDPI, QCanvas* canvas)
: Unit(resolutionDPI),
  font("feta26"),
  clefCanvas(canvas),
  clefView(canvas)
{
	QChar clef = 182;
	
	clefView.setFont(font);
	clefView.setText(clef);
}

TrackClassicalClefView::~TrackClassicalClefView()
{
}

/*
	Draw the bar on the display
*/
void TrackClassicalClefView::draw(const QPoint& position)
{
	clefView.move(position.x(), position.y());
	clefView.show();
}

double TrackClassicalClefView::width()
{
	QChar clef = 182;
	QFontMetrics fm(font);
	
	return convertDPIPixel<double>(fm.boundingRect(clef).width(), 75);
}

uint TrackClassicalClefView::height()
{
	return 0;
}
