/***************************************************************************
 * trackclassicalclefview.h: implementation of TrackClassicalClefView class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef TRACKCLASSICALCLEFVIEW_H
#define TRACKCLASSICALCLEFVIEW_H

#include <header.h>

#include "unit.h"

class TrackClassicalClefView : public Unit
{
public:
	TrackClassicalClefView(int resolutionDPI, QCanvas* canvas);
	~TrackClassicalClefView();
	
	/*
		Draw the bar on the display
	*/
	void draw(const QPoint& position);
	
	double width();
	uint height();
private:
	const QFont font;
	QCanvas* clefCanvas;
	QCanvasText clefView;
};

#endif
