#include "tabtimes.h"
#include "trackclassicaldurationview.h"

const float TrackClassicalDurationView::queueSpace = 0.1;

TrackClassicalDurationView::TrackClassicalDurationView(const TabTimes &times, int resolutionDPI, QCanvas *canvas)
: Unit(resolutionDPI),
  tabTimes(times),
  durationCanvas(canvas),
  barHeightDur(0),
  timeSpaceDur(0)
{
	lineList.setAutoDelete(true);
}

TrackClassicalDurationView::~TrackClassicalDurationView()
{
}

void TrackClassicalDurationView::setBarHeight(uint i)
{
	barHeightDur = i;
}

uint TrackClassicalDurationView::barHeight() const
{
	return barHeightDur;
}

void TrackClassicalDurationView::setTimeSpace(uint i)
{
	timeSpaceDur = i;
}

uint TrackClassicalDurationView::timeSpace() const
{
	return timeSpaceDur;
}

void TrackClassicalDurationView::draw(QPoint position, Duration nextDuration)
{
	drawVerticalLine(position);
	
	if (nextDuration != NoneDuration)
		drawFirstDuration(position, nextDuration);
	else
		drawLastDuration(position);
}

void TrackClassicalDurationView::drawVerticalLine(QPoint position)
{
	QCanvasLine* line = new QCanvasLine(durationCanvas);
	
	line->setPoints(position.x(), position.y(), position.x(), barHeightDur);
	line->show();
	
	lineList.append(line);
}

void TrackClassicalDurationView::drawFirstDuration(QPoint position, Duration nextDuration)
{
	uint nbLines = 0, nextNbLines = 0;
	
	switch (tabTimes.duration()) {
	case HundredTwentyEighth:
		nbLines = 5;
		break;
	case SixtyFourth:
		nbLines = 4;
		break;
	case ThirthSecond:  // 1/32 Triple croche
		nbLines = 3;
		break;
	case Sixteenth:  // 1/16 Double croche
		nbLines = 2;
		break;
	case Eighth:  // 1/8 Croche
		nbLines = 1;
		break;
	case Quarter: // 1/4 - a long vertical line, so we need to find the highest note
	case Half: // 1/2 Blanche
	case Whole: // whole Ronde
	case NoneDuration:
		break; 
	}
	
	for (uint i = 0; i < nbLines; i++) {
		QCanvasLine* line = new QCanvasLine(durationCanvas);
		
		line->setPoints(position.x(), barHeightDur + (i * cmToPixel(queueSpace)),
						position.x() + timeSpaceDur / 2, barHeightDur + (i * cmToPixel(queueSpace)));
		line->show();
		
		lineList.append(line);
	}
	
	switch (nextDuration) {
	case HundredTwentyEighth:
		nextNbLines = 5;
		break;
	case SixtyFourth:
		nextNbLines = 4;
		break;
	case ThirthSecond:  // 1/32 Triple croche
		nextNbLines = 3;
		break;
	case Sixteenth:  // 1/16 Double croche
		nextNbLines = 2;
		break;
	case Eighth:  // 1/8 Croche
		nextNbLines = 1;
		break;
	case Quarter: // 1/4 - a long vertical line, so we need to find the highest note
	case Half: // 1/2 Blanche
	case Whole: // whole Ronde
	case NoneDuration:
		break; 
	}
	
	if (nextNbLines < nbLines)
		nbLines = nextNbLines;
	
	// Draw the tablature duration
	//
	for (uint i = 0; i < nextNbLines; i++) {
		QCanvasLine* line = new QCanvasLine(durationCanvas);
		
		line->setPoints(position.x() + timeSpaceDur / 2, barHeightDur + (i * cmToPixel(queueSpace)),
						position.x() + timeSpaceDur, barHeightDur + (i * cmToPixel(queueSpace)));
		line->show();
		
		lineList.append(line);
	}
}

void TrackClassicalDurationView::drawLastDuration(QPoint position)
{
	uint nbLines = 0;
	
	switch (tabTimes.duration()) {
	case HundredTwentyEighth:
		nbLines = 5;
		break;
	case SixtyFourth:
		nbLines = 4;
		break;
	case ThirthSecond:  // 1/32 Triple croche
		nbLines = 3;
		break;
	case Sixteenth:  // 1/16 Double croche
		nbLines = 2;
		break;
	case Eighth:  // 1/8 Croche
		nbLines = 1;
		break;
	case Quarter: // 1/4 - a long vertical line, so we need to find the highest note
	case Half: // 1/2 Blanche
	case Whole: // whole Ronde
	case NoneDuration:
		break; 
	}
	
	for (uint i = 0; i < nbLines; i++) {
		QCanvasLine* line = new QCanvasLine(durationCanvas);
		
		line->setPoints(position.x() - timeSpaceDur / 2, barHeightDur + (i * cmToPixel(queueSpace)),
						position.x(), barHeightDur + (i * cmToPixel(queueSpace)));
		line->show();
		
		lineList.append(line);
	}
}
