/***************************************************************************
 * trackclassicaldurationview.h: implementation of TrackDurationView class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef TRACKCLASSICALDURATIONVIEW_H
#define TRACKCLASSICALDURATIONVIEW_H

#include <header.h>

#include "unit.h"

class TabTimes;

class TrackClassicalDurationView : Unit
{
public:
	TrackClassicalDurationView(const TabTimes &times, int resolutionDPI, QCanvas *canvas);
	~TrackClassicalDurationView();
	
	void setBarHeight(uint i);
	uint barHeight() const;
	
	void setTimeSpace(uint i);
	uint timeSpace() const;
	
	/*
		Draw the time on the screen
	*/
	void draw(QPoint position, Duration nextDuration);
private:
	// Space between the queue
	//
	static const float queueSpace;
	
	/*
		Draw vertical line for the HundredTwentyEighth to the Half
	*/
	void drawVerticalLine(QPoint position);
	
	/*
		The the first duration bar
	*/
	void drawFirstDuration(QPoint position, Duration nextDuration);
	
	/*
		The the last duration bar
	*/
	void drawLastDuration(QPoint position);
	
	// The current times
	//
	const TabTimes &tabTimes;
	
	// Canvas for the drawing
	//
	QCanvas* durationCanvas;
	
	QPtrList<QCanvasLine> lineList;
	
	// Height of the vertical bar
	//
	uint barHeightDur;
	
	// Space between this time and the other
	//
	uint timeSpaceDur;
};

#endif
