/***************************************************************************
 * trackdurationview.h: implementation of TrackDurationView class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef TRACKDURATIONVIEW_H
#define TRACKDURATIONVIEW_H

#include <header.h>

#include "unit.h"

class TabTimes;

class TrackDurationView : Unit
{
public:
	TrackDurationView(const TabTimes& times, uint strings, uint space, int width, int resolutionDPI, QCanvas* canvas);
	~TrackDurationView();
	
	/*
		Draw the time on the screen
	*/
	void draw(QPoint position, Duration nextDuration);
private:
	/*
		Draw vertical line for the HundredTwentyEighth to the Half
	*/
	void drawVerticalLine(QPoint position);
	
	/*
		The the first duration bar
	*/
	void drawFirstDuration(QPoint position, Duration nextDuration);
	
	/*
		The the last duration bar
	*/
	void drawLastDuration(QPoint position);
	
	static const double queueSpace;
	
	// The current time display
	//
	const TabTimes tabTimes;
	
	// Number of strings
	//
	const uint nbStrings;
	
	// Spaces between the lines
	//
	const uint lineSpaces;
	
	const int durationWidth;
	
	// Canvas for the drawing
	//
	QCanvas* durationCanvas;
	
	QPtrList<QCanvasLine> lineList;
};

#endif
