/***************************************************************************
 * tracklist.h: implementation of TrackList class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef TRACKLIST_H
#define TRACKLIST_H

#include <header.h>

#include "../sequencer/instruments.h"

class TabSong;
class TabTrack;

//! Part of main editor window, shows a list of tracks in a song.
/*!
	Has signals and slots to change display on selecting a new track
	and mouse event handlers to make selection of tracks by mouse
	possible.
*/
class TrackList: public QListView {
	Q_OBJECT
public:
	/*!
		Inits the default vars.
	*/
	TrackList(TabSong* song, KXMLGUIClient* xml, QWidget* parent = 0, const char* name = 0);
	
	/*!
		TODO Remove the qlistview !!
	*/
	~TrackList();
	
	/*!
		Update the list of tracks.
	*/
	void updateList();

signals:
	/*!
		Emited when a new track is selected.
	*/
	void trackChanged(TabTrack*);

protected:
	/*!
		Called when there is a mouse press event and
		select the new track.
		\param e The event.
	*/
	virtual void contentsMousePressEvent(QMouseEvent* e);

private slots:
	/*!
		Select a new track number.
		\param item The new track number.
	*/
	void selectNewTrack(QListViewItem* item);

private:
	InstrumentsList instruments;
	TabSong *tabSong;
	KXMLGUIClient *xmlGUIClient;
};

#endif
