/***************************************************************************
 * trackpageview.h: implementation of TrackPageView class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef TRACKPAGEVIEW_H
#define TRACKPAGEVIEW_H

#include <header.h>

#include "unit.h"

class TrackPageView : public Unit
{
public:
	TrackPageView(uint p, const QRect& size, int resolutionDPI, QCanvas* canvas);
	
private:
	QCanvasRectangle canvasRectangle;
	QRect pageSize;
	const uint page;
	QFont textFont;
	QFontMetrics textFontInfo;
	const int textWidth;
	const int textHeight;
	QCanvasText textCanvas;
};

#endif
