/***************************************************************************
 * trackpane.cpp: implementation of TrackPane class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#include "tabsong.h"
#include "trackpane.h"

TrackPane::TrackPane(TabSong *s, int hh, int cs, QWidget *parent, const char *name)
: QScrollView(parent, name)
{
	song = s;

//	setTableFlags(Tbl_autoHScrollBar | Tbl_smoothScrolling);
	setFrameStyle(Panel | Sunken);
	setBackgroundMode(PaletteBase);

	//	setFocusPolicy(QWidget::StrongFocus);

	cellSide = cs;
	headerHeight = hh;

	updateList();

	show();
}

void TrackPane::updateList()
{
	resizeContents(50 * cellSide, song->count() * cellSide + headerHeight);
	repaintContents();
}

// Draws that pretty squares for track pane.
void TrackPane::drawContents(QPainter *p, int clipx, int /*clipy*/, int clipw, int /*cliph*/)
{
	bool empty;
	uint x1 = clipx / cellSide;
	uint x2 = (clipx + clipw) / cellSide;
	
	int py = headerHeight;
	
	for (TabTrack* tabTrack = song->first(); tabTrack; tabTrack = song->next()) {
		int px = x1 * cellSide;
		for (uint i = x1; i <= x2; i++) {
			// Check if tabTrack is empty
			//
			empty = true;
			
			if (i < tabTrack->count()) {
				TabBar tempBar = tabTrack->bar(i);
				
				for (uint j = 0; j < tempBar.count(); j++)
					if (tempBar.times(j).isRest() == false) {
						empty = false;
						break;
					}
				
				if (empty == false)
					style().drawPrimitive(QStyle::PE_ButtonBevel, p, QRect(px, py, cellSide, cellSide), colorGroup());
				else
					style().drawPrimitive(QStyle::PE_FocusRect, p, QRect(px, py, cellSide, cellSide), colorGroup());
			}
			
			px += cellSide;
		}
		py += cellSide;
	}
}

void TrackPane::mousePressEvent(QMouseEvent *e)
{
	if (e->button() == LeftButton) {
		int barnum = e->pos().x() / cellSide;
		uint tracknum = (e->pos().y() - headerHeight) / cellSide;

		if (tracknum >= song->count())
			return;
		emit trackChanged(song->at(tracknum));
		emit newBarSelected(barnum);
	}
}
