/***************************************************************************
 * trackpos.cpp: implementation of TrackPos class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#include "trackpos.h"

TrackPos::TrackPos():curPos(0),curBarPos(0),curTimesPos(0)
{
}

void TrackPos::incChord()
{
	curPos++;
}

void TrackPos::decChord()
{
	if (curPos)
		curPos--;
}

void TrackPos::setChord(unsigned int chord)
{
	curPos = chord;
}

unsigned int TrackPos::chord() const
{
	return curPos;
}

void TrackPos::incBar()
{
	curBarPos++;
}

void TrackPos::decBar()
{
	if (curBarPos)
		curBarPos--;
}

void TrackPos::setBar(unsigned int bar)
{
	curBarPos = bar;
}

unsigned int TrackPos::bar() const
{
	return curBarPos;
}

void TrackPos::incTimes()
{
	curTimesPos++;
}

void TrackPos::decTimes()
{
	if (curTimesPos)
		curTimesPos--;
}

void TrackPos::setTimes(unsigned int notes)
{
	curTimesPos = notes;
}

unsigned int TrackPos::times() const
{
	return curTimesPos;
}
