#include "tracktabclefview.h"

const QString TrackTabClefView::tabText("TAB");

TrackTabClefView::TrackTabClefView(const QFont& clefFont, uint heighTablature, int resolutionDPI, QCanvas* canvas)
: Unit(resolutionDPI),
  font(clefFont),
  clefHeight(heighTablature),
  clefCanvas(canvas)
{
	for (uint i = 0; i < 3; i++)
		clefView[i] = new QCanvasText(tabText[i], font, clefCanvas);
}

TrackTabClefView::~TrackTabClefView()
{
	for (uint i = 0; i < 3; i++)
		delete clefView[i];
}

/*
	Draw the bar on the display
*/
void TrackTabClefView::draw(const QPoint& position)
{
	for (uint i = 0; i < 3; i++) {
		clefView[i]->move(position.x() + 2, position.y() + i * clefHeight / 3);
		clefView[i]->show();
	}
}

double TrackTabClefView::width()
{
	QFontMetrics fm(clefView[0]->font());
	double larger = 0.0, newLarger;
	
	for (uint i = 0; i < 3; i++)
		if ((newLarger = convertDPIPixel<double>(fm.boundingRect(tabText[i]).width(), 75)) > larger)
			larger = newLarger;
	
	return larger;
}

uint TrackTabClefView::height()
{
	return 0;
}
