/***************************************************************************
 * trackbarclefview.h: implementation of TrackTabClefView class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef TRACKTABCLEFVIEW_H
#define TRACKTABCLEFVIEW_H

#include <header.h>

#include "unit.h"

class TrackTabClefView : public Unit
{
public:
	TrackTabClefView(const QFont& clefFont, uint heightTablature, int resolutionDPI, QCanvas* canvas);
	~TrackTabClefView();
	
	/*
		Draw the bar on the display
	*/
	void draw(const QPoint& position);
	
	double width();
	uint height();
private:
	static const QString tabText;
	const QFont& font;
	const uint clefHeight;
	QCanvas* clefCanvas;
	QCanvasText* clefView[3];
};

#endif
