#include "tabsong.h"
#include "trackclassicaldurationview.h"
#include "tracktimesclassicalview.h"

#include <limits>

QPtrVector<QCanvasPixmapArray> TrackTimesClassicalView::restClassicalPixmap(7);

TrackTimesClassicalView::TrackTimesClassicalView(const TabTimes& times, const TrackProperties& properties, const QFont& textFont, uint strings, uint lSpace, uint tSpace, int resolutionDPI, QCanvas* canvas)
: Unit(resolutionDPI),
  tabTimes(times),
  trackProperties(properties),
  font(textFont),
  nbStrings(strings),
  lineSpaces(lSpace),
  timeSpaces(tSpace),
  timesCanvas(canvas),
  spriteView(0),
  heightNote(std::numeric_limits<int>::max()),
  lowNote(std::numeric_limits<int>::min())
{
	QString temp;
	
	if (restClassicalPixmap.isEmpty()) {
		for (uint i = 0; i < 7; i++)
			restClassicalPixmap.insert(i, new QCanvasPixmapArray(locate("data", "ktabedit/pics/silent" + temp.setNum(i + 1) + ".png")));
	}
	
	noteView.setAutoDelete(true);
	lineView.setAutoDelete(true);
}

TrackTimesClassicalView::~TrackTimesClassicalView()
{
	if (spriteView)
		delete spriteView;
}

void TrackTimesClassicalView::drawFret(const QPoint& position)
{
	QString string;
	QFontMetrics fm(font);
	
	for (unsigned int i = 0; i < nbStrings; i++) {
		if ((!tabTimes.notes(i).isEmpty()) && (!tabTimes.notes(i).isDeadNote() == true)) {
/*			kdDebug() << "prop = " << (uint)trackProperties.tune(nbStrings - i - 1) << "\n";
			kdDebug() << "octave = " << trackProperties.tune(nbStrings - i - 1) + tabTimes.notes(i).fret() << "\n";*/
			
			// At this time it's only working for the C Key
			//
			int octave = (trackProperties.tune(nbStrings - i - 1) + tabTimes.notes(i).fret()) / 12;
			uint realNote = (trackProperties.tune(nbStrings - i - 1) + tabTimes.notes(i).fret()) % 12;
			float note;
			
			// For the c tonality
			//
			switch (realNote) {
				case 0:
				case 1:
					note = 0.0;
					break;
				case 2:
				case 3:
					note = 0.5;
					break;
				case 4:
					note = 1.0;
					break;
				case 5:
				case 6:
					note = 1.5;
					break;
				case 7:
				case 8:
					note = 2.0;
					break;
				case 9:
				case 10:
					note = 2.5;
					break;
				case 11:
					note = 3.0;
					break;
			}
			
			int result = static_cast<int>(position.y() - (((octave - 4.0) * 3.5) * lineSpaces) 
				      - (note * lineSpaces) + lineSpaces);
			
			QCanvasEllipse* ellipseView = new QCanvasEllipse(cmToPixel(0.14), cmToPixel(0.14), timesCanvas);
			ellipseView->setBrush(Qt::black);
			ellipseView->move(position.x(), result);
			ellipseView->show();
			
			// Height note
			//
			if (result < heightNote)
				heightNote = result;
			
			// Lower note
			//
			if (result > lowNote)
				lowNote = result;
			
			// Drawn partition lines under E
			//
			if (octave <= 4) {
				int lineOctave = 4;
				float lineNote = 0.0;
				
				while (lineOctave > octave || (lineOctave == octave && lineNote >= note)) {
					QCanvasLine* line = new QCanvasLine(timesCanvas);
					int linePosition =  static_cast<int>(- (((lineOctave - 4) * 3.5) * lineSpaces) - (lineNote * lineSpaces) + lineSpaces);
					line->setPoints(position.x() - cmToPixel(0.2), position.y() + linePosition,
									position.x() + cmToPixel(0.2), position.y() + linePosition);
					line->show();
					
					lineView.append(line);
					
					lineNote--;
					
					if (lineNote < 0.0) {
						lineOctave--;
						lineNote = 3.5 + lineNote;
					}
				}
			} else if (octave >= 5){
				// Drawn partition lines above G
				//
				int lineOctave = 5;
				float lineNote = 2.5;
				
				while (lineOctave < octave || (lineOctave == octave && lineNote <= note)) {
					QCanvasLine* line = new QCanvasLine(timesCanvas);
					int linePosition =  static_cast<int>(- (((lineOctave - 4) * 3.5) * lineSpaces) - (lineNote * lineSpaces) + lineSpaces);
					line->setPoints(position.x() - cmToPixel(0.2), position.y() + linePosition,
									position.x() + cmToPixel(0.2), position.y() + linePosition);
					line->show();
					
					lineView.append(line);
					
					lineNote++;
					
					if (lineNote > 3.0) {
						lineOctave++;
						lineNote = -3.5 + lineNote;
					}
				}
			}

			noteView.append(ellipseView);
		}
	}
}

void TrackTimesClassicalView::draw(QPoint position, Duration nextDuration)
{
	if (tabTimes.isRest()) {
		switch (tabTimes.duration()) {
		case NoneDuration:
			break;
		case HundredTwentyEighth:
			spriteView = new QCanvasSprite(restClassicalPixmap[7], timesCanvas);
			break;
		case SixtyFourth:
			spriteView = new QCanvasSprite(restClassicalPixmap[6], timesCanvas);
			break;
		case ThirthSecond:  // 1/32
			spriteView = new QCanvasSprite(restClassicalPixmap[5], timesCanvas);
			break;
		case Sixteenth:  // 1/16
			spriteView = new QCanvasSprite(restClassicalPixmap[4], timesCanvas);
			break;
		case Eighth:  // 1/8
			spriteView = new QCanvasSprite(restClassicalPixmap[3], timesCanvas);
			break;
		case Quarter: // 1/4
			spriteView = new QCanvasSprite(restClassicalPixmap[2], timesCanvas);
			break;
		case Half: // 1/2
			spriteView = new QCanvasSprite(restClassicalPixmap[1], timesCanvas);
			break;
		case Whole: // whole
			spriteView = new QCanvasSprite(restClassicalPixmap[0], timesCanvas);
			break;
		}
		
		spriteView->move(position.x(), position.y() - 6 * lineSpaces);
		spriteView->show();

		durationView.reset();
	} else {
		drawFret(position);
		
		// There is nothing to draw
		//
		if (heightNote == std::numeric_limits<int>::max())
			return ;
		
		durationView.reset(new TrackClassicalDurationView(tabTimes, DPI(), timesCanvas));
		
		// Position of the heigher vertical line
		//
		durationView->setBarHeight(position.y() - 7 * lineSpaces);
		
		// Space between this time and the other
		//
		durationView->setTimeSpace(timeSpaces);
		
		// Move to the lowest note and to the side of the ellipse
		//
		position.setY(lowNote);
		position.setX(position.x() + cmToPixel(0.14) / 2);
		
		// Draw the duration
		//
		durationView->draw(position, nextDuration);
	}
}
