/***************************************************************************
 * tracktimeclassicalview.h: implementation of TrackTimeClassicalView class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2006-2007 the KTabEdit development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef TRACKTIMECLASSICALVIEW_H
#define TRACKTIMECLASSICALVIEW_H

#include <header.h>

#include "unit.h"

class TabSong;
class TrackBarLineView;
class TrackClassicalDurationView;

class TrackTimesClassicalView : public Unit
{
public:
	TrackTimesClassicalView(const TabTimes& times, const TrackProperties& properties, const QFont& textFont, 
				uint strings, uint lSpace, uint tSpace, int resolutionDPI, QCanvas* canvas);
	virtual ~TrackTimesClassicalView();
	
	/*
		Draw the time on the screen
	*/
	void draw(QPoint position, Duration nextDuration);
	
private:
	/*
		Draw the fret number
	*/
	void drawFret(const QPoint& position);

	// The current time display
	//
	const TabTimes tabTimes;
	
	// For the tuning
	//
	const TrackProperties trackProperties;
	
	// The text font
	//
	const QFont& font;
	
	// Number of strings
	//
	const uint nbStrings;
	
	// Spaces between the lines
	//
	const uint lineSpaces;
	
	// Spaces between the times
	//
	const uint timeSpaces;

	// Canvas for the drawing
	//
	QCanvas* timesCanvas;
	
	// Display the note
	//
	QPtrList<QCanvasEllipse> noteView;
	
	// List of the exceeding bars in the measure
	//
	QPtrList<QCanvasLine> lineView;
	
	// Rest pixmap
	//
	static QPtrVector<QCanvasPixmapArray> restClassicalPixmap;
	
	// Rest "sprite" with 0 frame
	//
	QCanvasSprite* spriteView;

	// Duration view
	//
	std::auto_ptr<TrackClassicalDurationView> durationView;

	// Bigger height of the notes
	//
	int heightNote;
	
	// Lower height of the notes
	//
	int lowNote;
};

#endif
