/***************************************************************************
 * tracktimesignatureview.h: implementation of TrackTimeSignatureView class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef TRACKTIMESIGNATUREVIEW_H
#define TRACKTIMESIGNATUREVIEW_H

#include <header.h>

#include "timesignature.h"
#include "unit.h"

class TrackTimeSignatureView : public Unit
{
public:
	TrackTimeSignatureView(const TimeSignature& signature, const QFont& font, int height, int resolutionDPI, QCanvas* canvas);
	~TrackTimeSignatureView();
	
	/*
		Draw the bar on the display
	*/
	void draw(QPoint position);
	
	double width() const;
	uint height() const;
	
private:
	const TimeSignature& timeSignature;
	QFont timeFont;
	const int timeHeight;
	QCanvasText* canvasView[2];
};

#endif
