#include "tabsong.h"
#include "tracktimesview.h"

QPtrVector<QCanvasPixmapArray> TrackTimesView::restPixmap(7);

TrackTimesView::TrackTimesView(const TabTimes& times, const QFont& textFont, uint strings, uint space, int resolutionDPI, QCanvas* canvas)
: Unit(resolutionDPI),
  tabTimes(times),
  font(textFont),
  nbStrings(strings),
  lineSpaces(space),
  timesCanvas(canvas),
  spriteView(0)
{
	QString temp;
	
	if (restPixmap.isEmpty()) {
		for (uint i = 0; i < 7; i++)
			restPixmap.insert(i, new QCanvasPixmapArray(locate("data", "ktabedit/pics/silent" + temp.setNum(i + 1) + ".png")));
	}
	
	fretView.setAutoDelete(true);
}

TrackTimesView::~TrackTimesView()
{
	if (spriteView)
		delete spriteView;
}

void TrackTimesView::drawFret(const QPoint& position)
{
	QString string;
	QFontMetrics fm(font);
	
	for (unsigned int i = 0; i < nbStrings; i++) {
// 		if (((!tabTimes.notes(i).isEmpty()) || (tabTimes.notes(i).isDeadNote() == true)) && (tabTimes.notes(i).isTieNote() == false)) {
		if ((!tabTimes.notes(i).isEmpty()) || (tabTimes.notes(i).isDeadNote() == true)) {
			if (tabTimes.notes(i).isDeadNote() == true)
				string = "X";
			else if (tabTimes.notes(i).isGhostNote())
				string = "(" + string.setNum(tabTimes.notes(i).fret()) + ")";
			else
				string = string.setNum(tabTimes.notes(i).fret());
			
			QCanvasText* canvasText = new QCanvasText(timesCanvas);
			
			canvasText->move(position.x(), position.y() + i * lineSpaces - convertDPIPixel(fm.boundingRect("8").height(), 75));
			canvasText->setFont(font);
			canvasText->setText(string);
			canvasText->show();
			
			fretView.append(canvasText);
		}
	}
}

void TrackTimesView::draw(QPoint position)
{
	if (tabTimes.isRest()) {
		switch (tabTimes.duration()) {
		case NoneDuration:
			break;
		case HundredTwentyEighth:
			spriteView = new QCanvasSprite(restPixmap[7], timesCanvas);
			break;
		case SixtyFourth:
			spriteView = new QCanvasSprite(restPixmap[6], timesCanvas);
			break;
		case ThirthSecond:  // 1/32
			spriteView = new QCanvasSprite(restPixmap[5], timesCanvas);
			break;
		case Sixteenth:  // 1/16
			spriteView = new QCanvasSprite(restPixmap[4], timesCanvas);
			break;
		case Eighth:  // 1/8
			spriteView = new QCanvasSprite(restPixmap[3], timesCanvas);
			break;
		case Quarter: // 1/4
			spriteView = new QCanvasSprite(restPixmap[2], timesCanvas);
			break;
		case Half: // 1/2
			spriteView = new QCanvasSprite(restPixmap[1], timesCanvas);
			break;
		case Whole: // whole
			spriteView = new QCanvasSprite(restPixmap[0], timesCanvas);
			break;
		}
		
		spriteView->move(position.x(), position.y());
		spriteView->show();
	} else
		drawFret(position);
}
