/***************************************************************************
 * tracktimeview.h: implementation of TrackTimeView class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef TRACKTIMEVIEW_H
#define TRACKTIMEVIEW_H

#include <header.h>

#include "unit.h"

class TabSong;
class TrackBarLineView;

class TrackTimesView : public Unit
{
public:
	TrackTimesView(const TabTimes& times, const QFont& textFont, uint strings, uint space, int resolutionDPI, QCanvas* canvas);
	virtual ~TrackTimesView();
	
	/*
		Draw the time on the screen
	*/
	void draw(QPoint position);
	
private:
	/*
		Draw the fret number
	*/
	void drawFret(const QPoint& position);
	
	// The current time display
	//
	const TabTimes tabTimes;
	
	// The text font
	//
	const QFont& font;
	
	// Number of strings
	//
	const uint nbStrings;
	
	// Spaces between the lines
	//
	const uint lineSpaces;
	
	// Canvas for the drawing
	//
	QCanvas* timesCanvas;
	
	// Display the fret number
	//
	QPtrList<QCanvasText> fretView;
	
	// Rest pixmap
	//
	static QPtrVector<QCanvasPixmapArray> restPixmap;
	
	// Rest "sprite" with 0 frame
	//
	QCanvasSprite* spriteView;
};

#endif
