#include "settings.h"
#include "tabsong.h"
#include "tracktitleview.h"

TrackTitleView::TrackTitleView(const TabSong& song, const QRect& size, int resolutionDPI, QCanvas* canvas)
: Unit(resolutionDPI),
  canvasText(canvas),
  pageSize(size),
  tabSong(song)
{
	// Font used for the title : the size of the font is 0.700 mm
	// or 0.2756 in and the size is converted in px
	//
	QFont fontTitle(Settings::titleFont(), Settings::titleSize(), Settings::titleWeight(), Settings::titleItalic());
	
	// Get the height of the font to get the spaces 
	// between the lines.
	//
	QFontMetrics fm(fontTitle);
	
	// Center the text
	//
	const int width = convertDPIPixel(fm.boundingRect(tabSong.title()).width(), 75);
	const int height = convertDPIPixel(fm.boundingRect(tabSong.title()).height(), 75);
	const int x = size.left() + ((size.width() - width) / 2);
	const int y = size.top() + height;
	
	canvasText.setText(tabSong.title());
	canvasText.setFont(fontTitle);
	canvasText.move(x, y);
	canvasText.show();
	
	rectSize.setRect(x, size.top(), width, height);
}
