#include "global.h"
#include "settings.h"
#include "tracktuningview.h"
#include "tabsong.h"
#include "tunings.h"


TrackTuningView::TrackTuningView(const TabTrack& track, const QRect& size, int resolutionDPI, QCanvas* canvas)
: Unit(resolutionDPI),
  tuningDescription(canvas),
  pageSize(size),
  tabTrack(track),
  nbStrings(track.nbStrings())
{
	int maxWidth = 0;
	int maxHeight = 0;
	
	// Print the word : "Tune Down 1/2 Step:"
	//                        Up   1 Step:"
	//
	QString text;
	
	// Font used for the text : the size of the font is 0.100 mm
	// or 0.0394 in and the size is converted in px
	//
	QFont fontText(Settings::textAndTabFont(), Settings::textAndTabSize(), Settings::textAndTabWeight(), Settings::textAndTabItalic());
	
	// Get the height of the font to get the spaces 
	// between the lines.
	//
	QFontMetrics fm(fontText);
	
	// Height of the font
	//
	const int numHeight = convertDPIPixel(fm.boundingRect("8").height(), 75) + cmToPixel(0.100);
	
	// Test if there is a description for the current tuning
	//
	for (uchar i = 0; lib_tuning[i].strings != 0; i++) {
		if (lib_tuning[i].strings == tabTrack.nbStrings()) {
			bool find;
			
			for (uchar j = 0; (find = j < tabTrack.nbStrings()); j++) {
				if (lib_tuning[i].shift[j] != tabTrack.tune(j))
					break;
			}
			
			if (find == false) {
				text = lib_tuning[i].name;
				break;
			}
		}
	}
	
	if (!text.isEmpty()) {
		// Center the text
		//
		const int x = pageSize.left() + cmToPixel(1.500);
		const int y = pageSize.top() + cmToPixel(0.500) + convertDPIPixel(fm.boundingRect(text).height(), 75);
		
		// Draw the text
		//
		tuningDescription.setText(text);
		tuningDescription.move(x, y);
		tuningDescription.setFont(fontText);
		tuningDescription.show();
		
		pageSize.setTop(y);
		
		maxWidth  = convertDPIPixel(tuningDescription.boundingRect().right(), 75);
		maxHeight = y;
	}
	
	ellipse[0]          = new QCanvasEllipse*[tabTrack.nbStrings()];
	ellipse[1]          = new QCanvasEllipse*[tabTrack.nbStrings()];
	canvasText[0]    = new QCanvasText*[tabTrack.nbStrings()];
	canvasText[1]    = new QCanvasText*[tabTrack.nbStrings()];
	
	for (uchar i = 0; i < tabTrack.nbStrings(); i++) {
		ellipse[0][i] = new QCanvasEllipse(canvas);
		ellipse[1][i] = new QCanvasEllipse(canvas);
		
		canvasText[0][i] = new QCanvasText(canvas);
		canvasText[1][i] = new QCanvasText(canvas);
	}
	
	
	// Count the number of rows
	//
	int countRows = 0;
	
	// Count the number of column
	//
	int countColumn = 0;
	
	// Display the tuning by group of 3 :
	//     first   ... fourth ... seventh
	//     second  ... fifth
	//     third   ... sixth  
	//
	for (uchar i = 0; i < nbStrings; i++) {
		const int x = pageSize.left() + cmToPixel(1.600) + countRows * cmToPixel(1.500);
		const int y = pageSize.top() + countColumn * numHeight + cmToPixel(0.300);
		const int width = convertDPIPixel(fm.boundingRect(text.setNum(i + 1)).width(), 75);
		
/*		ellipse[0][i]->setBrush(Qt::black);
		ellipse[0][i]->setSize(numHeight, numHeight);
		ellipse[0][i]->move(x, y + numHeight);
		ellipse[0][i]->show();
		
		ellipse[1][i]->setBrush(Qt::white);
		ellipse[1][i]->setSize(numHeight - 2, numHeight - 2);
		ellipse[1][i]->move(x, y + numHeight);
		ellipse[1][i]->show();*/
		
		// Draw the chord number
		//
		canvasText[0][i]->setText(text.setNum(i + 1));
		canvasText[0][i]->move(x, y + numHeight);
		canvasText[0][i]->setFont(fontText);
		canvasText[0][i]->show();
		
		// Draw the tuning
		//
		canvasText[1][i]->setText( " = " + Settings::noteName(tabTrack.tune(i) % 12));
		canvasText[1][i]->move(x + width, y + numHeight);
		canvasText[1][i]->setFont(fontText);
		canvasText[1][i]->show();
		
		countColumn++;
		
		if ((i + 1) % 3 == 0) {
			countColumn = 0;
			countRows++;
		}
	}
	
	const int x = cmToPixel(1.600) + 4 * cmToPixel(1.500);
	const int y = ((nbStrings / 3) + 3) * numHeight + cmToPixel(0.300);
	
	rectSize.setRect(pageSize.left(), pageSize.top(), x, y);
}

TrackTuningView::~TrackTuningView()
{
	for (uchar i = 0; i < nbStrings; i++) {
		delete ellipse[0][i];
		delete ellipse[1][i];
		
		delete canvasText[0][i];
		delete canvasText[1][i];
	}
	
	for (uchar i = 0; i < 2; i++) {
		delete ellipse[i];
		delete canvasText[i];
	}
	
}
