/***************************************************************************
 * tracktuningview.h: implementation of TrackTuningView class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef TRACKTUNINGVIEW_H
#define TRACKTUNINGVIEW_H

#include <header.h>

#include "unit.h"

class TabSong;
class TabTrack;

class TrackTuningView : public Unit
{
public:
	TrackTuningView(const TabTrack& track, const QRect& size, int resolutionDPI, QCanvas* canvas);
	~TrackTuningView();
	
	inline QRect size() const
	{ return rectSize; }
	
private:
	QCanvasEllipse** ellipse[2];
	QCanvasText**    canvasText[2];
	QCanvasText      tuningDescription;
	QRect pageSize;
	const TabTrack& tabTrack;
	uchar nbStrings;
	QRect rectSize;
};

#endif
