/***************************************************************************
 * unit.h: implementation of Unit class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef UNIT_H
#define UNIT_H

class Unit {
public:
	Unit(int resolutionDPI);
	
	inline int DPI() const
	{ return static_cast<int>(dpi); }
	
	//
	//
	inline int cmToPixel(double cm) const
	{ return static_cast<int>(dpi * (cm / inches)); }
	
	inline int cmToInches(double cm) const
	{ return static_cast<int>(cm / inches); }
	
	inline int inchesToPixel(double in) const
	{ return static_cast<int>(dpi * in); }
	
	inline int inchesToCm(double in) const
	{ return static_cast<int>(in * inches); }
	
	inline int pixelToCm(int pixel) const
	{ return static_cast<int>(pixel * inches / dpi); }
	
	inline int pixelToInches(int pixel) const
	{ return static_cast<int>(pixel / dpi); }
	
	// Converts pixel from a different DPI resolution to the current DPI resolution
	//
	inline int convertDPIPixel(int pixel, int oldDPI) const
	{ return static_cast<int>(static_cast<double>(dpi) * (static_cast<double>(pixel) / static_cast<double>(oldDPI))); }
	
	//
	//
	template <class T> inline T cmToPixel(double cm) const
	{ return static_cast<T>(dpi * (cm / inches)); }
	
	template <class T> inline T cmToInches(double cm) const
	{ return static_cast<T>(cm / inches); }
	
	template <class T> inline T inchesToPixel(double in) const
	{ return static_cast<T>(dpi * in); }
	
	template <class T> inline T inchesToCm(double in) const
	{ return static_cast<T>(in * inches); }
	
	template <class T> inline T pixelToCm(int pixel) const
	{ return static_cast<T>(pixel * inches / dpi); }
	
	template <class T> inline T pixelToInches(int pixel) const
	{ return static_cast<T>(pixel / dpi); }
	
	// Converts pixel from a different DPI resolution to the current DPI resolution
	//
	template <class T> inline T convertDPIPixel(int pixel, int oldDPI) const
	{ return static_cast<T>(static_cast<double>(dpi) * (static_cast<double>(pixel) / static_cast<double>(oldDPI))); }
	
private:
	const double dpi;
	static const double inches;
};

#endif
