/* $Id: gui-GTK_addframe-dialog.c,v 1.3 2005/03/20 22:26:54 emvi Exp $ */

/* 
Copyright (C) 2005 Marek Wardziski (emvi at emvi eu org) 
 
This file is part of Ant. 
 
Ant is free software; you can redistribute it and/or modify 
it under the terms of the GNU General Public License as published by 
the Free Software Foundation; either version 2 of the License, or 
(at your option) any later version. 
 
Ant is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
GNU General Public License for more details. 
 
You should have received a copy of the GNU General Public License 
along with Ant; if not, write to the Free Software 
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include "main.h" 
#include "misc.h" 

#include <gtk/gtk.h> 
#include "gui-GTK.h" 
#include "gui-GTK_handlers.h"

GtkWidget *addframe_dialog_window;
GtkWidget *addframe_dialog_radio_empty;
GtkWidget *addframe_dialog_radio_copy;
GtkWidget *addframe_dialog_hbox1;
GtkWidget *addframe_dialog_label2;
GtkWidget *addframe_dialog_combo_place;
GtkWidget *addframe_dialog_label3;
GtkWidget *addframe_dialog_spin_framenr;

void addframe_dialog_create() {
    int nr_frames;

    addframe_dialog_window = gtk_dialog_new_with_buttons(_("Add frame"),
				GTK_WINDOW(window_main),
				GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
                		GTK_STOCK_OK, GTK_RESPONSE_OK,
                		GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                		NULL);
    addframe_dialog_radio_empty = gtk_radio_button_new_with_label(NULL, _("Create empty frame"));
    addframe_dialog_radio_copy = gtk_radio_button_new_with_label_from_widget(
					    GTK_RADIO_BUTTON(addframe_dialog_radio_empty),
					    _("Copy current frame"));

    addframe_dialog_hbox1 = gtk_hbox_new(TRUE, 5);
    addframe_dialog_label2 = gtk_label_new(_("Insert frame"));
    addframe_dialog_combo_place = gtk_combo_box_new_text();
    gtk_combo_box_append_text((GtkComboBox*) addframe_dialog_combo_place, _("before"));
    gtk_combo_box_append_text((GtkComboBox*) addframe_dialog_combo_place, _("after"));
    gtk_combo_box_set_active((GtkComboBox*) addframe_dialog_combo_place, 1);
    gtk_box_pack_start(GTK_BOX(addframe_dialog_hbox1), addframe_dialog_label2, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(addframe_dialog_hbox1), addframe_dialog_combo_place, TRUE, TRUE, 2);

    nr_frames = g_list_length(all_frames);
    if (nr_frames == 1) {
	addframe_dialog_label3 = gtk_label_new(_("frame no. 1"));
    } else {
	addframe_dialog_label3 = gtk_label_new(_("frame no."));
	addframe_dialog_spin_framenr = gtk_spin_button_new_with_range(1, nr_frames, 1);
	g_signal_connect(G_OBJECT(addframe_dialog_spin_framenr), "button-press-event", G_CALLBACK(entry_mouseclicked), NULL);
	gtk_spin_button_set_numeric((GtkSpinButton*) addframe_dialog_spin_framenr, TRUE);
	gtk_spin_button_set_value((GtkSpinButton*) addframe_dialog_spin_framenr, nr_frames);
	gtk_entry_set_max_length((GtkEntry*)addframe_dialog_spin_framenr, 6);
	gtk_entry_set_width_chars((GtkEntry*)addframe_dialog_spin_framenr, 6);
	gtk_box_pack_end(GTK_BOX(addframe_dialog_hbox1), addframe_dialog_spin_framenr, TRUE, TRUE, 2);
    }
    gtk_box_pack_end(GTK_BOX(addframe_dialog_hbox1), addframe_dialog_label3, TRUE, TRUE, 2);

    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(addframe_dialog_window)->vbox), addframe_dialog_radio_empty, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(addframe_dialog_window)->vbox), addframe_dialog_radio_copy, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(addframe_dialog_window)->vbox), addframe_dialog_hbox1, TRUE, TRUE, 2);
    gtk_widget_show_all(addframe_dialog_window);

}
